% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-ydayarith.R, R/op-cdo-ydayadd.R,
%   R/op-cdo-ydaydiv.R, R/op-cdo-ydaymul.R, R/op-cdo-ydaysub.R
\name{ydayarith}
\alias{ydayarith}
\alias{cdo_ydayadd}
\alias{cdo_ydaydiv}
\alias{cdo_ydaymul}
\alias{cdo_ydaysub}
\title{Multiyear daily arithmetic}
\usage{
cdo_ydayadd(ifile1, ifile2, ofile = NULL)

cdo_ydaydiv(ifile1, ifile2, ofile = NULL)

cdo_ydaymul(ifile1, ifile2, ofile = NULL)

cdo_ydaysub(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module performs simple arithmetic of a time series and one timestep with the same day of year. For each field in infile1 the corresponding field of the timestep in infile2 with the same day of year is used. The input files need to have the same structure with the same variables. Usually infile2 is generated by an operator of the module YDAYSTAT.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ydayadd  Add multi-year daily time series
         Adds a time series and a multi-year daily time series.
ydaysub  Subtract multi-year daily time series
         Subtracts a time series and a multi-year daily time series.
ydaymul  Multiply multi-year daily time series
         Multiplies a time series and a multi-year daily time series.
ydaydiv  Divide multi-year daily time series
         Divides a time series and a multi-year daily time series.
}\if{html}{\out{</div>}}
}
