% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_elements.R
\name{add_subtitle}
\alias{add_subtitle}
\title{Add a subtitle above a reactable table}
\usage{
add_subtitle(
  table = NULL,
  subtitle = NULL,
  align = "left",
  font_color = "#000",
  font_size = 24,
  font_style = "normal",
  font_weight = "bold",
  text_decoration = NULL,
  text_transform = NULL,
  letter_spacing = NULL,
  word_spacing = NULL,
  text_shadow = NULL,
  background_color = "#FFFFFF",
  margin = NULL
)
}
\arguments{
\item{table}{A reactable table.}

\item{subtitle}{A string to be displayed as the subtitle.}

\item{align}{The alignment of the subtitle.
Options are "left", "right", "center".
Default is "left".}

\item{font_color}{Color of the subtitle text.
Default is #000.}

\item{font_size}{Numeric value representing the size of the font of the subtitle (in px).
Default is 24.}

\item{font_style}{Style of the subtitle font.
Options are "normal" or "italic".
Default is "normal".}

\item{font_weight}{The font weight of the subtitle.
Options are "bold" or "normal".
Default is "bold".}

\item{text_decoration}{Add an underline, overline, or line-through subtitle.
Options are "underline", "overline", "underline overline", or "line-through".
Default is NULL.}

\item{text_transform}{Specify how to capitalize the title.
Options are "uppercase", "lowercase", or "capitalize".
Default is NULL.}

\item{letter_spacing}{Numeric value that adjusts the horizontal spacing between letters.
A number above 0 adds more spacing between letters, a number below 0 decreases the spacing.
Default is NULL.}

\item{word_spacing}{Numeric value that adjusts the horizontal spacing between words.
A number above 0 adds more spacing between words, a number below 0 decreases the spacing.
Default is NULL.}

\item{text_shadow}{Apply a shadow around the title.
See <https://developer.mozilla.org/en-US/docs/Web/CSS/text-shadow> for options.
Default is NULL.}

\item{background_color}{Color of the subtitle background.
Default is #FFFFFF.}

\item{margin}{Use margin() to set the margin around the text (top, right, bottom, left).
Default is NULL.}
}
\value{
a function that adds a subtitle above a reactable table.
}
\description{
Use `add_subtitle()` to place a subtitle above a {reactable} or {reactablefmtr} table.
     The same options that are present in `add_title()` and `add_source()` are also available in `add_subtitle()`.
     The subtitle can be aligned to the left, right, or center with the align option.
     The text properties of the subtitle, such as the font size and font style can be customized.
     The background color of the subtitle can also be adjusted as well as the margin around the subtitle.
}
\examples{
\dontrun{
## Create the reactable table and then pipe in the subtitle
table <- reactable(iris[10:29, ])

table \%>\%
  add_subtitle("This is a subtitle")

## If a title proceeds a subtitle, the subtite will be placed below the title
table \%>\%
  add_title("This is a title") \%>\%
  add_subtitle("This is a subtitle")

## Use options to adjust the style and position of the subtitle
table \%>\%
  add_subtitle("This is a subtitle", align = "center", font_color = "red")
}
}
