% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abares_trade.R
\name{read_abares_trade}
\alias{read_abares_trade}
\title{Read Data from the ABARES Trade Dashboard}
\source{
\url{https://daff.ent.sirsidynix.net.au/client/en_AU/search/asset/1033841/0}
}
\usage{
read_abares_trade(x = NULL)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \CRANpkg{data.table} object of the \acronym{ABARES} trade data.
}
\description{
Fetches and imports \acronym{ABARES} trade data. As the data x is large,
~1.4GB uncompressed \acronym{CSV} x.
}
\note{
Columns are renamed for consistency with other \acronym{ABARES} products
serviced in this package using a snake_case format and ordered
consistently.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
trade <- read_abares_trade()

trade
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.agriculture.gov.au/abares/research-topics/trade/dashboard}
}
\seealso{
Other Trade: 
\code{\link{read_abares_trade_regions}()}
}
\concept{Trade}
