% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_plots.R
\name{refdb_plot_tax_tree}
\alias{refdb_plot_tax_tree}
\title{Reference database taxonomy tree}
\usage{
refdb_plot_tax_tree(
  x,
  leaf_col = NULL,
  color_col = NULL,
  freq_labels = 0,
  expand_plot = 0.5
)
}
\arguments{
\item{x}{a reference database.}

\item{leaf_col}{a column name referring to the taxonomic level
for the leaves of the tree. If not provided (\code{NULL})
the function tries to find a relevant level.}

\item{color_col}{a column name referring to the taxonomic level
for the color of the leaves (must be higher or equal to the level
of \code{leaf_col}). If not provided (\code{NULL})
the function tries to find a relevant level.}

\item{freq_labels}{a numeric value to adjust
the number of printed labels (minimum frequency).
Default is zero which means all non-NA labels are printed.}

\item{expand_plot}{a value to expand the limits of the plot.
Useful if the labels are too long.}
}
\value{
A \pkg{ggplot2} (\pkg{ggraph}) object. This means the plot
can be further customized using \pkg{ggplot2} compatible functions.
}
\description{
Represent the hierarchical structure of the taxonomic information
of a reference database as a tree.
}
\details{
The underlying graph is computed using the non-exported function
\code{igraph_from_taxo}.
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_plot_tax_tree(lib)

}
