% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reeb-graph-pairs.R
\name{reeb_graph_pairs}
\alias{reeb_graph_pairs}
\alias{reeb_graph_pairs.default}
\alias{reeb_graph_pairs.igraph}
\alias{reeb_graph_pairs.network}
\alias{reeb_graph_pairs.reeb_graph}
\alias{as.data.frame.reeb_graph_pairs}
\alias{print.reeb_graph_pairs}
\alias{format.reeb_graph_pairs}
\title{Pair Reeb Graph Critical Points via Java}
\usage{
reeb_graph_pairs(
  x,
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  ...
)

\method{reeb_graph_pairs}{default}(
  x,
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  ...
)

\method{reeb_graph_pairs}{igraph}(
  x,
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  values = NULL,
  ...
)

\method{reeb_graph_pairs}{network}(
  x,
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  values = NULL,
  ...
)

\method{reeb_graph_pairs}{reeb_graph}(
  x,
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  ...
)

\method{as.data.frame}{reeb_graph_pairs}(x, ...)

\method{print}{reeb_graph_pairs}(x, ..., n = NULL, minlength = 12L)

\method{format}{reeb_graph_pairs}(x, ..., n = NULL, minlength = 12L)
}
\arguments{
\item{x}{A \code{\link{reeb_graph}} object.}

\item{sublevel}{Logical; whether to use the sublevel set filtration (\code{TRUE},
the default) or else the superlevel set filtration (via reversing
\code{x[["values"]]} before paring critical points.}

\item{method}{Character; the pairing method to use. Matched to
\code{"single_pass"} (the default) or \code{"multi_pass"}.}

\item{...}{Additional arguments passed to methods.}

\item{values}{For coercion \emph{to} class \code{reeb_graph}, a character value; the
node attribute to use as the Reeb graph value function. If \code{NULL} (the
default), the first numeric node attribute is used. For coercion \emph{from}
class \code{reeb_graph}, a character value; the name of the node attribute in
which to store the Reeb graph value function.}

\item{n}{Integer number of critical pairs to print.}

\item{minlength}{Minimum name abbreviation length; passed to
\code{\link[base:abbreviate]{base::abbreviate()}}.}
}
\value{
A list of subclass \link{reeb_graph_pairs} containing 4 2-column matrices
characterizing the low- and high-valued critical points of each pair:
\describe{
\item{\code{type}}{
Character; the type of critical point,
one of \code{LEAF_MIN}, \code{LEAF_MAX}, \code{UPFORK}, and \code{DOWNFORK}.
}
\item{\code{value}}{
Double; the value (stored in \code{x[["values"]]}) of the critical point.
}
\item{\code{index}}{
Integer; the index (used in \code{x[["edgelist"]]}) of the critical point.
Regular points will not appear,
while degenerate critical points will appear multiple times.
}
\item{\code{order}}{
Integer; the order of the critical point in the pairing.
This is based on the conditioned Reeb graph constructed internally
so will not be duplicated.
}
}
The data frame also has attributes \code{"names"} for the node names, \code{"method"}
for the method used, and \code{"elapsed_time"} for the elapsed time.
}
\description{
This function calls one of two methods, merge-pair and
propagate-and-pair, to pair the critical points of a Reeb graph.
}
\details{
The function uses the \code{rJava} package to call either of two Java
methods from \code{ReebGraphPairing}. Ensure the Java Virtual Machine (JVM) is
initialized and the required class is available in the class path.

The Propagate-and-Pair algorithm (\code{"single_pass"}) performs both join and
split merge tree operations along a single sweep through the Reeb graph. It
was shown to be more efficient on most test data, and to scale better with
graph size, than an algorithm (\code{"multi_pass"}) that pairs some types along
the sublevel filtration and others along the superlevel filtration (Tu &al,
2019).

The output S3 class is a list of 2-column matrices containing the types,
values, indices, and orders of persistent pairs, with attributes containing
the node names and metadata. The \code{\link[=print]{print()}} method visually expresses each
pair, increasing from left to right, with nodes formatted as with
\link{reeb_graph}.

The names of the coerced data frame use \code{lo_} and \code{hi_} prefixes, in
contrast to the Java source code that uses \code{birth_} and \code{death_}. This is
meant to distinguish the pairs and their metadata from \link[=reeb_graph_persistence]{persistent homology}, which is here reformulated following
Carrière & Oudot (2018).
}
\examples{
ex_sf <- system.file("extdata", "running_example.txt", package = "rgph")
( ex_rg <- read_reeb_graph(ex_sf) )
( ex_cp <- reeb_graph_pairs(ex_rg) )
attr(ex_cp, "method")
attr(ex_cp, "elapsed_time")

reeb_graph_pairs(ex_rg, sublevel = FALSE)

x <- reeb_graph(
  values = c(0, .4, .6, 1),
  edgelist = c( 1,2, 1,3, 2,4, 3,4 )
)
( mp <- reeb_graph_pairs(x) )
class(mp)
as.data.frame(mp)

names(x$values) <- letters[seq_along(x$values)]
( mp <- reeb_graph_pairs(x) )
as.data.frame(mp)

\dontshow{if (rlang::is_installed("network")) withAutoprint(\{ # examplesIf}
library(network)
data("emon")
mtsi <- emon$Cheyenne
mtsi_reeb <- as_reeb_graph(
  mtsi,
  values = "Command.Rank.Score",
  names = "vertex.names"
)
mtsi_cp <- reeb_graph_pairs(mtsi_reeb, sublevel = FALSE)
print(mtsi_cp, minlength = 20)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://github.com/USFDataVisualization/ReebGraphPairing/}

Tu J, Hajij M, Rosen P. Propagate and Pair: A Single-Pass Approach to
Critical Point Pairing in Reeb Graphs. In: Bebis G, Boyle R, Parvin B, &al,
eds. \emph{Advances in Visual Computing. Lecture Notes in Computer Science}.
Springer International Publishing; 2019:99--113.
\doi{10.1007/978-3-030-33720-9_8}

Carrière M & Oudot S (2018) "Structure and Stability of the One-Dimensional
Mapper". \emph{Foundations of Computational Mathematics} 18(6): 1333--1396.
\doi{10.1007/s10208-017-9370-z}
}
\seealso{
\code{\link[=reeb_graph_persistence]{reeb_graph_persistence()}}
}
