% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{calculateconnections}
\alias{calculateconnections}
\title{Calculate the Connectivity Matrix for a River Network}
\usage{
calculateconnections(lines, tolerance)
}
\arguments{
\item{lines}{A list of coordinate matrices, each corresponding to a line segment.}

\item{tolerance}{The spatial tolerance for establishing connectivity.}
}
\value{
A matrix with topological information.  See the \code{$connections} element of the \link{rivernetwork-class}.
}
\description{
Calculates the connectivity matrix for a river network, during import and editing.  Called internally.
}
\examples{
Gulk_connections <- calculateconnections(lines=Gulk$lines, tolerance=Gulk$tolerance)
}
\author{
Matt Tyers
}
