/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.outlier;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.arima.estimation.FastKalmanFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class FastOutlierDetector<T extends IArimaModel>
extends SingleOutlierDetector<T> {
    private double[] el;
    private IArimaModel stmodel;
    private BackFilter ur;
    private double mad;

    public FastOutlierDetector(RobustStandardDeviationComputer computer) {
        super(computer == null ? RobustStandardDeviationComputer.mad() : computer);
    }

    @Override
    protected boolean calc() {
        if (this.getOutlierFactoriesCount() == 0 || this.ubound <= this.lbound) {
            return false;
        }
        if (!this.initmodel()) {
            return false;
        }
        for (int i = 0; i < this.getOutlierFactoriesCount(); ++i) {
            this.processOutlier(i);
        }
        return true;
    }

    @Override
    protected void clear(boolean all) {
        super.clear(all);
        this.el = null;
    }

    private boolean initmodel() {
        StationaryTransformation st = this.getRegArima().arima().stationaryTransformation();
        this.stmodel = (IArimaModel)st.getStationaryModel();
        this.ur = st.getUnitRoots();
        ConcentratedLikelihoodWithMissing cll = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(this.getRegArima());
        DoubleSeq residuals = this.fullResiduals(this.getRegArima().differencedModel(), cll);
        this.el = residuals.toArray();
        this.mad = this.getStandardDeviationComputer().compute(residuals);
        return true;
    }

    private void processOutlier(int idx) {
        int nl = this.el.length;
        int d = this.ur.getDegree();
        int n = nl + d;
        IOutlierFactory.FilterRepresentation representation = this.getOutlierFactory(idx).getFilterRepresentation();
        if (representation == null) {
            return;
        }
        Object model = this.getRegArima().arima();
        RationalBackFilter pi = model.getPiWeights();
        double[] o = pi.times(representation.filter).getWeights(n);
        double corr = 0.0;
        if (d == 0 && representation.correction != 0.0) {
            Polynomial ar = model.getAr().asPolynomial();
            Polynomial ma = model.getMa().asPolynomial();
            corr = representation.correction * ar.evaluateAt(1.0) / ma.evaluateAt(1.0);
            int i = 0;
            while (i < n) {
                int n2 = i++;
                o[n2] = o[n2] + corr;
            }
        }
        double sxx = 0.0;
        if (corr != 0.0) {
            sxx = corr * corr * (double)nl;
        }
        int lb = this.getLBound();
        int ub = this.getUBound();
        for (int ix = 0; ix < n; ++ix) {
            int pos;
            int kmax;
            sxx += o[ix] * o[ix];
            if (corr != 0.0) {
                sxx -= corr * corr;
            }
            if ((kmax = ix + 1) > nl) {
                kmax = nl;
                sxx -= o[ix - nl] * o[ix - nl];
                if (corr != 0.0) {
                    sxx += corr * corr;
                }
            }
            double sxy = 0.0;
            int k = 0;
            int ek = nl - 1;
            while (k < kmax) {
                sxy += this.el[ek] * o[ix - k];
                ++k;
                --ek;
            }
            if (corr != 0.0) {
                double cxy = 0.0;
                for (int k2 = 0; k2 < nl - kmax; ++k2) {
                    cxy += this.el[k2];
                }
                sxy += cxy * corr;
            }
            if (this.isAllowed(pos = n - 1 - ix, idx) && pos >= lb && pos < ub) {
                double c = sxy / sxx;
                double val = c * Math.sqrt(sxx) / this.mad;
                this.setCoefficient(pos, idx, c);
                this.setT(pos, idx, val);
                continue;
            }
            this.setT(pos, idx, Double.NaN);
            this.setCoefficient(pos, idx, Double.NaN);
        }
    }

    private DoubleSeq fullResiduals(RegArmaModel<T> differencedModel, ConcentratedLikelihoodWithMissing cll) {
        if (cll.allCoefficients().isEmpty()) {
            return cll.e();
        }
        DataBlock res = differencedModel.asLinearModel().calcResiduals(cll.allCoefficients());
        FastKalmanFilter filter = new FastKalmanFilter(this.stmodel);
        Likelihood ll = filter.process((DoubleSeq)res);
        return ll.e();
    }
}

