/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats;

import java.util.Arrays;
import java.util.function.DoublePredicate;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;

public final class DescriptiveStatistics {
    private final double[] data;
    private final double sx;
    private final double sxx;
    private final int nmissings;
    private final double skewness;
    private final double kurtosis;
    private volatile double[] obs;
    private volatile double[] sortedObs;

    public static boolean isSmall(double val) {
        return Math.abs(val) < Constants.getEpsilon();
    }

    public static DescriptiveStatistics of(DoubleSeq data) {
        return new DescriptiveStatistics(data.toArray());
    }

    public static DescriptiveStatistics ofInternal(double[] data) {
        return new DescriptiveStatistics(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] obs() {
        double[] tmp = this.obs;
        if (tmp == null) {
            DescriptiveStatistics descriptiveStatistics = this;
            synchronized (descriptiveStatistics) {
                tmp = this.obs;
                if (tmp == null) {
                    if (this.nmissings == 0) {
                        tmp = this.data;
                    } else {
                        tmp = new double[this.data.length - this.nmissings];
                        int j = 0;
                        for (int i = 0; i < this.data.length; ++i) {
                            double x = this.data[i];
                            if (!Double.isFinite(x)) continue;
                            tmp[j++] = x;
                        }
                    }
                    this.obs = tmp;
                }
            }
        }
        return this.obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] sortObs() {
        double[] tmp = this.sortedObs;
        if (tmp == null) {
            double[] cobs = this.obs();
            DescriptiveStatistics descriptiveStatistics = this;
            synchronized (descriptiveStatistics) {
                tmp = this.sortedObs;
                if (tmp == null) {
                    tmp = (double[])cobs.clone();
                    Arrays.sort(tmp);
                    this.sortedObs = tmp;
                }
            }
        }
        return this.sortedObs;
    }

    private DescriptiveStatistics(double[] data) {
        this.data = data;
        double s_x = 0.0;
        double s_xx = 0.0;
        int nm = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            double v = data[i];
            if (!Double.isFinite(v)) {
                ++nm;
                continue;
            }
            s_x += v;
            s_xx += v * v;
        }
        this.sx = s_x;
        this.sxx = s_xx;
        this.nmissings = nm;
        int nc = n - this.nmissings;
        double mu = this.sx / (double)nc;
        double sxxc = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double v = data[i];
            if (!Double.isFinite(v)) continue;
            double e = v - mu;
            sxxc += e * e;
        }
        double v = sxxc / (double)nc;
        double stdev = Math.sqrt(v);
        double skew = 0.0;
        double kurt = 0.0;
        double stdev3 = v * stdev;
        for (int i = 0; i < n; ++i) {
            double cur = data[i];
            if (!Double.isFinite(cur)) continue;
            double m3 = (cur -= mu) * cur * cur;
            skew += m3;
            kurt += m3 * cur;
        }
        this.skewness = skew / (stdev3 * (double)nc);
        this.kurtosis = kurt / (v * v * (double)nc);
    }

    public int countBetween(double a, double b) {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            int i1;
            int i0;
            int n = tmp.length;
            if (n == 0) {
                return 0;
            }
            for (i0 = 0; i0 < n && tmp[i0] < a; ++i0) {
            }
            for (i1 = i0; i1 < n && tmp[i1] < b; ++i1) {
            }
            return i1 - i0;
        }
        int n = this.data.length;
        int m = 0;
        for (int i = 0; i < n; ++i) {
            double v = this.data[i];
            if (!Double.isFinite(v) || !(v >= a) || !(v < b)) continue;
            ++m;
        }
        return m;
    }

    public double getAverage() {
        return this.sx / (double)(this.data.length - this.nmissings);
    }

    public int getDataCount() {
        return this.data.length;
    }

    public double getKurtosis() {
        return this.kurtosis;
    }

    public double getMax() {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp[tmp.length - 1];
        }
        int n = this.data.length;
        double sent = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            double v = this.data[i];
            if (!Double.isFinite(v) || !(v > sent)) continue;
            sent = v;
        }
        return sent;
    }

    public double getMedian() {
        boolean even;
        double[] tmp = this.sortObs();
        if (tmp.length == 0) {
            return Double.NaN;
        }
        boolean bl = even = tmp.length % 2 == 0;
        if (even) {
            return (tmp[tmp.length / 2 - 1] + tmp[tmp.length / 2]) / 2.0;
        }
        return tmp[tmp.length / 2];
    }

    public double getMin() {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp[0];
        }
        int n = this.data.length;
        double sent = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            double v = this.data[i];
            if (!Double.isFinite(v) || !(v < sent)) continue;
            sent = v;
        }
        return sent;
    }

    public int getMissingValuesCount() {
        return this.nmissings;
    }

    public int getObservationsCount() {
        return this.data.length - this.nmissings;
    }

    public double getSkewness() {
        return this.skewness;
    }

    public double getStdev() {
        return Math.sqrt(this.getVar());
    }

    public double getStdevDF(int df) {
        return Math.sqrt(this.getVarDF(df));
    }

    public double getSum() {
        return this.sx;
    }

    public double getSumSquare() {
        return this.sxx;
    }

    public double getVar() {
        return this.getVarDF(0);
    }

    public double getVarDF(int df) {
        int n = this.data.length - this.nmissings;
        double sxxc = 0.0;
        double m = this.sx / (double)n;
        for (int i = 0; i < this.data.length; ++i) {
            double v = this.data[i];
            if (!Double.isFinite(v)) continue;
            double e = v - m;
            sxxc += e * e;
        }
        return sxxc / (double)(n - df);
    }

    public double getRmse() {
        int n = this.data.length - this.nmissings;
        return Math.sqrt(this.sxx / (double)n);
    }

    public boolean hasZeroes() {
        double[] tmp = this.sortedObs;
        if (tmp != null && tmp.length > 0 && (tmp[0] > 0.0 || tmp[tmp.length - 1] < 0.0)) {
            return false;
        }
        return !this.allObservationsMatch(x -> x != 0.0);
    }

    public boolean isConstant() {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            if (tmp.length == 0) {
                return true;
            }
            return tmp[0] == tmp[tmp.length - 1];
        }
        double sent = Double.NaN;
        for (int i = 0; i < this.data.length; ++i) {
            double v = this.data[i];
            if (!Double.isFinite(v)) continue;
            if (Double.isNaN(sent)) {
                sent = v;
                continue;
            }
            if (v == sent) continue;
            return false;
        }
        return true;
    }

    public boolean isGreater(double val) {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp.length == 0 ? true : tmp[0] > val;
        }
        return this.allObservationsMatch(x -> x > val);
    }

    public boolean isGreaterOrEqual(double val) {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp.length == 0 ? true : tmp[0] >= val;
        }
        return this.allObservationsMatch(x -> x >= val);
    }

    public boolean isNegative() {
        return this.isSmaller(0.0);
    }

    public boolean isNegativeOrNull() {
        return this.isSmallerOrEqual(0.0);
    }

    public boolean isPositive() {
        return this.isGreater(0.0);
    }

    public boolean isPositiveOrNull() {
        return this.isGreaterOrEqual(0.0);
    }

    public boolean isSmaller(double val) {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp.length == 0 ? true : tmp[tmp.length - 1] < val;
        }
        return this.allObservationsMatch(x -> x < val);
    }

    public boolean isSmallerOrEqual(double val) {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp.length == 0 ? true : tmp[tmp.length - 1] <= val;
        }
        return this.allObservationsMatch(x -> x <= val);
    }

    public boolean isZero(double eps) {
        double[] tmp = this.sortedObs;
        if (tmp != null) {
            return tmp[0] >= -eps && tmp[tmp.length - 1] <= eps;
        }
        return this.allObservationsMatch(x -> Math.abs(x) <= eps);
    }

    public boolean allObservationsMatch(DoublePredicate condition) {
        double[] tmp = this.obs;
        if (tmp != null) {
            for (int i = 0; i < tmp.length; ++i) {
                if (condition.test(tmp[i])) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.data.length; ++i) {
            double x = this.data[i];
            if (!Double.isFinite(x) || condition.test(x)) continue;
            return false;
        }
        return true;
    }

    public double[] quantiles(int partitions) {
        double[] tmp = this.sortObs();
        int n = tmp.length;
        if (n == 0) {
            return null;
        }
        if (partitions < 2 || n / partitions < 1) {
            return null;
        }
        int np = partitions - 1;
        double[] res = new double[np];
        int ns = (n - 1) / partitions;
        if (ns * partitions == n - 1) {
            for (int i = 0; i < np; ++i) {
                res[i] = tmp[(i + 1) * ns];
            }
        } else {
            double ds = (double)(n - 1) / (double)partitions;
            for (int i = 0; i < np; ++i) {
                double dindex = (double)(i + 1) * ds;
                int lo = (int)dindex;
                double dlo = dindex - (double)lo;
                res[i] = tmp[lo] * (1.0 - dlo) + tmp[lo + 1] * dlo;
            }
        }
        return res;
    }

    public DoubleSeq sortedObservations() {
        return DoubleSeq.of((double[])this.sortObs());
    }

    public DoubleSeq observations() {
        return DoubleSeq.of((double[])this.obs());
    }

    public DoubleSeq data() {
        return DoubleSeq.of((double[])this.data);
    }
}

