% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splines.R
\name{periodic_bsplines}
\alias{periodic_bsplines}
\title{Periodic B-Splines}
\usage{
periodic_bsplines(order = 4, period = 1, knots, pos)
}
\arguments{
\item{order}{Order of the splines (4 for cubic)}

\item{period}{Period of the splines (1 by default)}

\item{knots}{Knots of the splines (in [0, period[)}

\item{pos}{Requested positions (in [0, period[). The rows of the returned matrix
will correspond to those positions}
}
\value{
A matrix (len(pos) x len(knots))
}
\description{
Periodic B-Splines
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s<-periodic_bsplines(knots = c(0,.2,.3, .9,.95), pos=seq(0,1,0.01))
matplot(s, type='l')
\dontshow{\}) # examplesIf}
}
