% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_seasonality.R
\name{seasonality_friedman}
\alias{seasonality_friedman}
\title{Friedman Seasonality Test}
\usage{
seasonality_friedman(data, period = NA, nyears = 0)
}
\arguments{
\item{data}{the input data.}

\item{period}{Tested periodicity. Can be missing if the input is a time series}

\item{nyears}{Number of periods or number of cycles considered in the test, at the end of the series:
in periods (positive value) or years (negative values).
By default (\code{nyears = 0}), the entire sample is used.}
}
\value{
A \code{c("JD3_TEST", "JD3")} object (see \code{\link[=statisticaltest]{statisticaltest()}} for details).
}
\description{
Friedman Seasonality Test
}
\details{
Non parametric test ("ANOVA"-type).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s <- do_stationary(log(ABS$X0.2.09.10.M))$ddata
seasonality_friedman(s)
seasonality_friedman(random_t(2, 1000), 12)
\dontshow{\}) # examplesIf}
}
