% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{trigonometric_variables}
\alias{trigonometric_variables}
\title{Trigonometric variables}
\usage{
trigonometric_variables(frequency, start, length, s, seasonal_frequency = NULL)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}

\item{seasonal_frequency}{the seasonal frequencies.
By default the fundamental seasonal frequency and all the harmonics are used.}
}
\value{
a mts object with 2 columns
}
\description{
Computes trigonometric variables at different frequencies.
}
\details{
Denote by \eqn{P} the value of \code{frequency} (= the period) and
\eqn{f_1}, ..., \eqn{f_n} the frequencies provides by \code{seasonal_frequency}
(if \code{seasonal_frequency = NULL} then \eqn{n=\lfloor P/2\rfloor} and \eqn{f_i}=i).

\code{trigonometric_variables} returns a matrix of size \eqn{length\times(2n)}.

For each date \eqn{t} associated to the period \eqn{m} (\eqn{m\in[1,P]}),
the columns \eqn{2i} and \eqn{2i-1} are equal to:
\deqn{
\cos \left(
\frac{2 \pi}{P}  \times m \times f_i
\right)
\text{ and }
\sin \left(
\frac{2 \pi}{P} \times m \times f_i
\right)
}
Take for example the case when the first date (\code{date}) is a January, \code{frequency = 12}
(monthly time series), \code{length = 12} and \code{seasonal_frequency = NULL}.
The first frequency, \eqn{\lambda_1 = 2\pi /12} represents the fundamental seasonal frequency and the
other frequencies (\eqn{\lambda_2 = 2\pi /12 \times 2}, ..., \eqn{\lambda_6 = 2\pi /12 \times 6})
are the five harmonics. The output matrix will be equal to:
\deqn{
\begin{pmatrix}
\cos(\lambda_1) & \sin (\lambda_1) & \cdots &
\cos(\lambda_6) & \sin (\lambda_6) \\
\cos(\lambda_1\times 2) & \sin (\lambda_1\times 2) & \cdots &
\cos(\lambda_6\times 2) & \sin (\lambda_6\times 2)\\
\vdots & \vdots & \cdots & \vdots & \vdots \\
\cos(\lambda_1\times 12) & \sin (\lambda_1\times 12) & \cdots &
\cos(\lambda_6\times 12) & \sin (\lambda_6\times 12)
\end{pmatrix}
}
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
trigonometric_variables(
    frequency = 12,
    length = 480,
    start = c(1990, 1),
    seasonal_frequency = 3
)
\dontshow{\}) # examplesIf}
}
