% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_document_base.R
\name{html_document_base}
\alias{html_document_base}
\title{Base output format for HTML-based output formats}
\usage{
html_document_base(
  theme = NULL,
  self_contained = TRUE,
  lib_dir = NULL,
  math_method = "default",
  mathjax = "default",
  pandoc_args = NULL,
  template = "default",
  dependency_resolver = NULL,
  copy_resources = FALSE,
  extra_dependencies = NULL,
  css = NULL,
  bootstrap_compatible = FALSE,
  ...
)
}
\arguments{
\item{theme}{One of the following:
\itemize{
\item A \code{\link[bslib:bs_theme]{bslib::bs_theme()}} object (or a list of \code{\link[bslib:bs_theme]{bslib::bs_theme()}} argument values)
\itemize{
\item Use this option for custom themes using Bootstrap 4 or 3.
\item In this case, any \code{.scss}/\code{.sass} files provided to the \code{css}
parameter may utilize the \code{theme}'s underlying Sass utilities
(e.g., variables, mixins, etc).
}
\item \code{NULL} for no theme (i.e., no \code{\link[=html_dependency_bootstrap]{html_dependency_bootstrap()}}).
\item A character string specifying a \href{https://bootswatch.com/3/}{Bootswatch 3}
theme name (for backwards-compatibility).
}}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\verb{_files} appended to it.}

\item{math_method}{Math rendering engine to use. This will define the math method to use with Pandoc.
\itemize{
\item It can be a string for the engine, one of "mathjax", "mathml", "webtex", "katex", "gladtex", or "r-katex"
or "default" for \code{mathjax}.
\item It can be a list of
\itemize{
\item \code{engine}:  one of
"mathjax", "mathml", "webtex", "katex", or "gladtex".
\item \code{url}: A specific url to use with \code{mathjax}, \code{katex} or \code{webtex}.
Note that for \code{engine = "mathjax"}, \code{url = "local"} will use a local version of MathJax (which is
copied into the output directory).
}
}

For example,

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{output:
  html_document:
    math_method:
      engine: katex
      url: https://cdn.jsdelivr.net/npm/katex@0.11.1/dist
}\if{html}{\out{</div>}}

See \href{https://pandoc.org/MANUAL.html#math-rendering-in-html}{Pandoc's Manual about Math in HTML} for the details
about Pandoc supported methods.

Using \code{math_method = "r-katex"} will opt-in server side rendering using
KaTeX thanks to \href{https://docs.ropensci.org/katex/}{katex} R package. This is
useful compared to \code{math_method = "katex"} to have no JS dependency, only a
CSS dependency for styling equation.}

\item{mathjax}{Include mathjax. The "default" option uses an https URL from a
MathJax CDN. The "local" option uses a local version of MathJax (which is
copied into the output directory). You can pass an alternate URL or pass
\code{NULL} to exclude MathJax entirely.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've created.
Note that if you don't use the "default" template then some features of
\code{html_document} won't be available (see the Templates section below for
more details).}

\item{dependency_resolver}{A dependency resolver}

\item{copy_resources}{Copy resources}

\item{extra_dependencies}{Extra dependencies as a list of the
\code{html_dependency} class objects typically generated by
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.}

\item{css}{CSS and/or Sass files to include. Files with an extension of .sass
or .scss are compiled to CSS via \code{sass::sass()}. Also, if \code{theme} is a
\code{\link[bslib:bs_theme]{bslib::bs_theme()}} object, Sass code may reference the relevant Bootstrap
Sass variables, functions, mixins, etc.}

\item{bootstrap_compatible}{Bootstrap compatible}

\item{...}{Ignored}
}
\value{
HTML base output format.
}
\description{
Creates an HTML base output format suitable for passing as the
\code{base_format} argument of the \code{\link{output_format}} function.
}
