% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rriskDistributions_functions.R
\name{get.chisq.par}
\alias{get.chisq.par}
\title{Fitting parameter of a chi-square distribution from one or more quantiles}
\usage{
get.chisq.par(p = c(0.025, 0.5, 0.975), q, show.output = TRUE,
   plot = TRUE, tol = 0.001, fit.weights = rep(1, length(p)), scaleX = c(0.1, 0.9), ...)
}
\arguments{
\item{p}{numeric, single value or vector of probabilities.}

\item{q}{numeric, single value or vector of quantiles corresponding to p.}

\item{show.output}{logical, if \code{TRUE} the \code{optim} result will be printed (default value is \code{TRUE}).}

\item{plot}{logical, if \code{TRUE} the graphical diagnostics will be plotted (default value is \code{TRUE}).}

\item{tol}{numeric, single positive value giving the absolute convergence tolerance for reaching zero (default value is \code{0.001}).}

\item{fit.weights}{numerical vector of the same length as a probabilities vector 
\code{p} containing positive values for weighting quantiles. By default all
quantiles will be weighted by 1.}

\item{scaleX}{numerical vector of the length 2 containing values (from the open interval (0, 1)).
for scaling quantile-axis (relevant only if \code{plot = TRUE}). The smaller the left value,
the further the graph is extrapolated within the lower percentile, the greater the right
value, the further it goes within the upper percentile.}

\item{...}{further arguments passed to the functions \code{plot} and \code{points} (relevant only if \code{plot = TRUE})}
}
\value{
Returns fitted parameters of a chi-square distribution or missing
values (\code{NA}'s), if the distribution cannot fit the specified quantiles.
}
\description{
\code{get.chisq.par} returns the parameters of a chi-square distribution where
the \code{p}th percentiles match with the quantiles \code{q}.
}
\details{
The number of probabilities, the number of quantiles and the number of weightings
must be identical and should be at least one. Using the default \code{p}, the
three corresponding quantiles are the 2.5th percentile, the median and the
97.5th percentile, respectively. \code{get.chisq.par} uses the R function \code{optim}
with the method \code{L-BFGS-B}.
\cr \cr
If \code{show.output = TRUE} the output of the function \code{optim} will be shown.
The item \code{convergence} equal to 0 means the successful completion of the
optimization procedure, otherwise it indicates a convergence error. The item
\code{value} displays the achieved minimal value of the functions that were minimized.
\cr \cr
The estimated distribution parameters returned by the function \code{optim} are
accepted, if the achieved value of the minimized function (output component
\code{value} of \code{optim}) is smaller than the argument \code{tol}.
\cr \cr
The items of the probability vector \code{p} should lie between 0 and 1.
\cr \cr
The items of the weighting vector \code{fit.weights} should be positive values.
The function which will be minimized is defined as a sum of squared differences
between the given probabilities and the theoretical probabilities of the specified
distribution evaluated at the given quantile points (least squares estimation).
}
\note{
It should be noted that there might be deviations between the estimated
and the theoretical distribution parameters in certain circumstances. This is
because the estimation of the parameters is based on a numerical optimization
method and depends strongly on the initial values. In addition, one must always
keep in mind that a distribution for different combinations of parameters may
look very similar. Therefore, the optimization method cannot always find the
"right" distribution, but a "similar" one.
\cr \cr
If the function terminates with the error massage "convergence error occurred or
specified tolerance not achieved", one may try to set the convergence tolerance
to a higher value. It is yet to be noted, that good till very good fits of parameters
could only be obtained for tolerance values that are smaller than 0.001.
}
\examples{
q <- stats::qchisq(p = c(0.025, 0.5, 0.975), df = 1)
old.par <- graphics::par(mfrow = c(2, 3))
get.chisq.par(q = q)
get.chisq.par(q = q, fit.weights = c(10, 1, 10))
get.chisq.par(q = q, fit.weights = c(100, 1, 100))
get.chisq.par(q = q, fit.weights = c(1, 10, 1))
get.chisq.par(q = q, fit.weights = c(1, 100, 1))
graphics::par(old.par)

q <- stats::qchisq(p = c(0.025, 0.5, 0.975), df = 0.1)
old.par <- graphics::par(mfrow = c(2, 3))
get.chisq.par(q = q, scaleX = c(0.1, 0.1))
get.chisq.par(q = q, fit.weights = c(10, 1, 10))
get.chisq.par(q = q, fit.weights = c(100, 1, 100))
get.chisq.par(q = q, fit.weights = c(1, 10, 1))
get.chisq.par(q = q, fit.weights = c(1, 100, 1))
graphics::par(old.par)

q <- stats::qchisq(p = c(0.025, 0.5, 0.975), df = 20)
old.par <- graphics::par(mfrow = c(2, 3))
get.chisq.par(q = q)
get.chisq.par(q = q, fit.weights = c(10, 1, 10))
get.chisq.par(q = q, fit.weights = c(100, 1, 100))
get.chisq.par(q = q, fit.weights =c(1, 10, 1))
get.chisq.par(q = q, fit.weights =c(1, 100, 1))
graphics::par(old.par)

## example with only one quantile
q <- stats::qchisq(p = c(0.025), df = 20)
old.par <- graphics::par(mfrow = c(1, 3))
get.chisq.par(p = c(0.025), q = q)
get.chisq.par(p = c(0.025), q = q, fit.weights = 10)
get.chisq.par(p = c(0.025), q = q, fit.weights = 100)
graphics::par(old.par)

}
\seealso{
See \code{pchisq} for distribution implementation details.
}
\author{
Matthias Greiner \email{matthias.greiner@bfr.bund.de} (BfR), \cr
Katharina Schueller \email{schueller@stat-up.de} (\acronym{STAT-UP} Statistical Consulting), \cr
Natalia Belgorodski \email{belgorodski@stat-up.de} (\acronym{STAT-UP} Statistical Consulting)
}
\keyword{fitpercentiles}
