% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{table_structure}
\alias{table_structure}
\title{Summarize table}
\usage{
table_structure(x, detail = c("subtable", "row"))
}
\arguments{
\item{x}{(\code{VTableTree})\cr a table object.}

\item{detail}{(\code{string})\cr either \code{row} or \code{subtable}.}
}
\value{
No return value. Called for the side-effect of printing a row- or subtable-structure summary of \code{x}.
}
\description{
Summarize table
}
\examples{
\dontshow{if (require(dplyr)) withAutoprint(\{ # examplesIf}
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

lyt <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"),
    afun = list_wrap_x(summary),
    format = "xx.xx"
  )

tbl <- build_table(lyt, iris2)
tbl

row_paths(tbl)

table_structure(tbl)

table_structure(tbl, detail = "row")
\dontshow{\}) # examplesIf}
}
