\name{GC.adjust}
\alias{GC.adjust}
\title{
GC Content Adjustment
}
\description{
This function adjusts log2ratio by GC content using LOESS.
}
\usage{
GC.adjust(data, gc, maxNumDataPoints = 10000)
}
\arguments{
  \item{data}{A data frame generated by \code{\link{cnv.data}} 
	or \code{\link{snp.cnv.data}}.
}
  \item{gc}{A data frame containing three columns: \code{chr}, \code{position} 
  	and \code{GC}. See the example data below for details.
}
  \item{maxNumDataPoints}{The maximum number of data points used for loess fit.
  	Default is 10000.
}
}
\details{
The method for GC content adjustment was adopted from CNAnorm (Gusnato et al. 2012).
}
\value{A data frame containing the log2ratio (GC adjusted) and log2mBAF values 
	for each probe site in the same format as generated by \code{\link{cnv.data}} 
	or \code{\link{snp.cnv.data}}. The original log2ratio is renamed as 
	\code{log2ratio.woGCAdj}. The GC-adjusted log2ratio is nameed as \code{log2ratio}.
}
\references{
Gusnanto, A, Wood HM, Pawitan Y, Rabbitts P, Berri S (2012) Correcting for 
cancer genome size and tumour cell content enables better estimation of 
copy number alterations from next-generation sequence data. 
\emph{Bioinformatics}, \bold{28}:40-47.
}
\author{
Zhongyang Zhang <zhongyang.zhang@mssm.edu>
}
\note{
This function is optional in the analysis pipeline and is now in beta version.
}
\seealso{
\code{\link{cnv.data}}, \code{\link{snp.cnv.data}}
}
\examples{
## CNV data generated by cnv.data
data(seq.data)
head(seq.data)

\dontrun{
## an example GC content file
url <- "https://zhangz05.u.hpc.mssm.edu/saasCNV/data/GC_1kb_hg19.txt.gz"
tryCatch({download.file(url=url, destfile="GC_1kb_hg19.txt.gz")
         }, error = function(e) {
          download.file(url=url, destfile="GC_1kb_hg19.txt.gz", method="curl")
         })
## If download.file fails to download the data, please manually download it from the url.

gc <- read.delim(file = "GC_1kb_hg19.txt.gz", as.is=TRUE)
head(gc)

## GC content adjustment
seq.data <- GC.adjust(data = seq.data, gc = gc, maxNumDataPoints = 10000)
head(seq.data)
}

}
\keyword{ CNV }
\keyword{ GC content }

