% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriveDatetag.R
\name{guessDatetagsSimple}
\alias{guessDatetagsSimple}
\alias{guessDatetagsSimple.snowprofileSet}
\alias{guessDatetagsSimple.snowprofile}
\alias{guessDatetagsSimple.snowprofileLayers}
\title{Guess datetags from deposition dates in simulated profiles}
\usage{
guessDatetagsSimple(x, adjust_bdates = TRUE, ...)

\method{guessDatetagsSimple}{snowprofileSet}(x, adjust_bdates = TRUE, ...)

\method{guessDatetagsSimple}{snowprofile}(x, adjust_bdates = TRUE, checkMonotonicity = FALSE, ...)

\method{guessDatetagsSimple}{snowprofileLayers}(x, adjust_bdates = TRUE, checkMonotonicity = TRUE, ...)
}
\arguments{
\item{x}{a \link{snowprofileSet}, \link{snowprofile} or \link{snowprofileLayers} object}

\item{adjust_bdates}{boolean switch to compute bdates similar to human interpretation. see Details.}

\item{...}{passed on to subsequent methods}

\item{checkMonotonicity}{check ascending order of layers. This acts as a check for whether multiple layers objects are stacked, which is not allowed.}
}
\value{
The input object will be returned with the columns \code{datetag} and \code{bdate} added to the profile layers
}
\description{
This routine provides a simple heuristic for assigning datetags to layers.
Datetags usually are deposition dates for crust layers, and burial dates for
other weak layers (e.g., SH, FC). If no datetags can be derived, a datetag
column of NAs will be added. Burial dates (\code{bdate}) are computed via
\link{deriveBDate}.
}
\section{Methods (by class)}{
\itemize{
\item \code{guessDatetagsSimple(snowprofileSet)}: for \link{snowprofileSet}s

\item \code{guessDatetagsSimple(snowprofile)}: for \link{snowprofile}s

\item \code{guessDatetagsSimple(snowprofileLayers)}: for \link{snowprofileLayers}

}}
\author{
fherla
}
