% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{scMetaTraj_embed}
\alias{scMetaTraj_embed}
\title{Embed cells in metabolic feature space}
\usage{
scMetaTraj_embed(
  scores,
  method = c("PCA", "UMAP"),
  n_pcs = 10,
  umap_n_neighbors = 30,
  umap_min_dist = 0.3,
  seed = 123
)
}
\arguments{
\item{scores}{Numeric matrix, cells x pathways.}

\item{method}{Character. "PCA" (default) or "UMAP".}

\item{n_pcs}{Integer. Number of PCs to return / use.}

\item{umap_n_neighbors}{Integer. UMAP n_neighbors.}

\item{umap_min_dist}{Numeric. UMAP min_dist.}

\item{seed}{Integer. Random seed.}
}
\value{
A numeric matrix:
\itemize{
\item PCA: cells x PCs
\item UMAP: cells x 2
}
}
\description{
scMetaTraj_embed() constructs a low-dimensional representation
of cells based on pathway-level metabolic scores.

DESIGN PRINCIPLES:
\itemize{
\item PCA is the true analysis space (for graph construction).
\item UMAP is ONLY for visualization.
}
}
