% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{norm_single_u_allocation_p_value}
\alias{norm_single_u_allocation_p_value}
\title{Compute the normal-approximation-based z-score and p-value for
a given 2 by 2, 2 by 3, 2 by 4, 2 by 5, 3 by 2, 4 by 2, or 3 by 3 contingency table.}
\usage{
norm_single_u_allocation_p_value(
  obs.table,
  gamma,
  delta,
  u_allocation,
  row = "treatment",
  treatment.scores,
  outcome.scores,
  shared_divisor = 1e+06
)
}
\arguments{
\item{obs.table}{A matrix or table object representing the contingency table.
Rows represent treatments, columns represent outcomes.}

\item{gamma}{A nonnegative scalar}

\item{delta}{A binary vector.
Must have length equal to the number of treatments. Can contain at most two unique values.}

\item{u_allocation}{A numeric vector of unmeasured confounder allocations for each outcome category.
Must have length equal to the number of outcomes. Each entry must be non-negative
and not exceed the corresponding outcome margin.}

\item{row}{Character indicating whether rows represent "treatment" or "outcome".
If "outcome", the table will be transposed. Default is "treatment".}

\item{treatment.scores}{A numeric vector of scores for treatments. Must be monotone (either
increasing or decreasing). Higher scores typically indicate more intense treatments.}

\item{outcome.scores}{A numeric vector of scores for outcomes. Must be monotone (either
increasing or decreasing). Higher scores typically indicate better outcomes.}

\item{shared_divisor}{A numeric value used for numerical stability in the Rcpp computations.
Default is 1e6.}
}
\value{
A list containing:
\item{T_obs}{The observed test statistic}
\item{mu_T}{The expected value of the test statistic under the null hypothesis}
\item{var_T}{The variance of the test statistic under the null hypothesis}
\item{z_score}{The standardized test statistic (T_obs - mu_T) / sqrt(var_T)}
\item{p_value}{The one sided upper tailed p-value based on the normal approximation}
\item{treatment.scores}{The treatment scores used}
\item{outcome.scores}{The outcome scores used}
}
\description{
This function performs a score test for ordinal association in contingency tables
with fixed margins under a sensitivity analysis framework. It uses the test statistic
\eqn{T = \sum A_{ij} N_{ij}} where \eqn{A_{ij} = w_i v_j} (treatment score X outcome score)
and computes the mean and variance under the null hypothesis using the Poisson-binomial
approximation for the multivariate Fisher's noncentral hypergeometric distribution.
}
\details{
The function implements a score test for ordinal association where the test statistic
is a weighted sum of the cell counts, with weights given by the product of treatment
and outcome scores.
The function uses specialized Rcpp functions to compute the mean and variance-covariance
structure of the free cells (those with degrees of freedom), then recovers the full
mean vector and covariance matrix using the marginal constraints. The test statistic
and its moments are then computed using matrix operations.
}
\examples{
# 2x3 contingency table
obs.table <- matrix(c(10, 20, 30, 15, 25, 10), nrow = 2, byrow = TRUE)

# Sensitivity parameters and u_allocation
gamma = 0.5
delta <- c(0, 1)
u_allocation <- c(5, 10, 8)

# Ordinal scores
treatment.scores <- c(0, 1)
outcome.scores <- c(0, 1, 2)

# Perform test
result <- norm_single_u_allocation_p_value(
  obs.table = obs.table,
  gamma = gamma,
  delta = delta,
  u_allocation = u_allocation,
  treatment.scores = treatment.scores,
  outcome.scores = outcome.scores
)

}
