% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_custom_fields_utils.R
\name{st_combine_filters}
\alias{st_combine_filters}
\title{Combine Multiple Filters}
\usage{
st_combine_filters(filter_ids, operator = c("AND", "OR"), auth_token = NULL)
}
\arguments{
\item{filter_ids}{Character vector. Existing filter IDs to combine}

\item{operator}{Character. How to combine filters ("AND" or "OR")}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}
}
\value{
Character string containing the combined filter ID
}
\description{
Creates a compound filter by combining multiple filter criteria.
}
\note{
OR operations may not be supported by all Sensor Tower endpoints
}
\examples{
\dontrun{
# Get Word Puzzle games (AND operation)
word_filter <- st_filter_by_genre(sub_genres = "Word")
puzzle_filter <- st_filter_by_genre(genres = "Puzzle")
combined <- st_combine_filters(
  filter_ids = c(word_filter, puzzle_filter),
  operator = "AND"
)
}

}
