% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkGPR_marg_samples_2D}
\alias{plot.shrinkGPR_marg_samples_2D}
\title{Plot method for 2D marginal predictions from \code{shrinkGPR}}
\usage{
\method{plot}{shrinkGPR_marg_samples_2D}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"shrinkGPR_marg_samples_2D"}, typically returned by
\code{\link{gen_marginal_samples}} when evaluating two covariates.}

\item{...}{Additional arguments passed to \code{\link[plotly]{add_surface}} for customizing the appearance
of the surface plot (e.g., \code{opacity}, \code{colorscale}, \code{showscale}).}
}
\value{
A \code{plotly} plot object (interactive 3D surface). Can be further customized via pipes and \code{plotly} functions.
}
\description{
Generates a 3D surface plot of 2D conditional predictive samples produced by \code{\link{gen_marginal_samples}}.
}
\details{
The function visualizes the posterior predictive mean across a 2D grid of evaluation points for two covariates.
Interactive plotting is handled via the \pkg{plotly} package. Axis labels are automatically inferred from the object.

Note: The \pkg{plotly} package must be installed to use this function.
}
\examples{
\donttest{
# Simulate data
set.seed(123)
torch::torch_manual_seed(123)
n <- 100
x <- matrix(runif(n * 2), n, 2)
y <- sin(2 * pi * x[, 1]) * cos(2 * pi * x[, 2]) + rnorm(n, sd = 0.1)
data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

# Fit GPR model
res <- shrinkGPR(y ~ x1 + x2, data = data)

# Generate marginal predictions for x1 and x2 jointly
marginal_samps_both <- gen_marginal_samples(res, to_eval = c("x1", "x2"), nsamp = 100)

# Plot interactive surface
plot(marginal_samps_both)

# Customize surface appearance
plot(marginal_samps_both, opacity = 0.8, colorscale = "Magma")

# Customize further via plotly
p <- plot(marginal_samps_both, opacity = 0.8, colorscale = "Magma")

p |> plotly::layout(
  scene = list(
    xaxis = list(title = "Covariate 1"),
    yaxis = list(title = "Covariate 2"),
    zaxis = list(title = "Expected value")
  )
)
}

}
\seealso{
\code{\link{gen_marginal_samples}}, \code{\link[plotly]{plot_ly}}, \code{\link[plotly]{add_surface}}

Other plotting functions: 
\code{\link{plot.shrinkGPR}()},
\code{\link{plot.shrinkGPR_marg_samples_1D}()},
\code{\link{plot.shrinkTPR}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
