% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str.sivs.R
\name{str.sivs}
\alias{str.sivs}
\title{Structure of sivs object}
\usage{
\method{str}{sivs}(
  object,
  max_depth = 2,
  max_leaves = 2,
  max_width = options("width")$width,
  ...
)
}
\arguments{
\item{object}{An object of class "sivs" or "list".}

\item{max_depth}{A numerical value of length 1 indicating how many layers the
function should dive into.}

\item{max_leaves}{A numericl vector of length 1 indicating how many of the
objects of each list should be shown.}

\item{max_width}{A numerical vector of length 1 indicating the maximum width
of the terminal that should be used by the function. If there are any lines
larger than this value, they will be truncated. Default is the terminal size
that is retuned by R.}

\item{...}{potential further arguments (required for Method/Generic reasons).}
}
\value{
The function uses `cat` to output general structure of sivs object
in human readable format in a tree-like structure.
}
\description{
This function shows the structure of a an object of either class
"sivs" or "list" and shows the internal structure of the object in
human-readable format. sivs object is a complex S3 object and it might be a
deterrent to users to get to know if better. This function is aiming to
facilitate the experience of user.
}
\examples{

## WORKING EXAMPLE
## Note that this example does not logically make sense as iris data has only
## 4 columns and there is no need for SIVS to take care of feature selection
## therefore this example is only here for testing purposes.

tmp <- subset(x = iris, subset = Species != "setosa")

tmp <- varhandle::unfactor(tmp)

sivs_obj <- sivs(x = tmp[, c("Sepal.Length", "Sepal.Width",
                             "Petal.Length", "Petal.Width")],
                 y = factor(tmp$Species),
                 family = "binomial",
                 verbose = "detailed",
                 progressbar = FALSE,
                 nfolds = 3,
                 parallel.cores = FALSE,
                 iter.count = 20)

str(sivs_obj)


}
