% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sketch}
\alias{sketch}
\title{Apply the sketch effect on an image}
\usage{
sketch(
  im,
  style = 1,
  lineweight = 1,
  smooth = ceiling(lineweight),
  gain = 0.02,
  contrast = NULL,
  shadow = 0,
  max.size = 2048
)
}
\arguments{
\item{im}{an image (array).}

\item{style}{a numeric (integer). Either 1 or 2.}

\item{lineweight}{a numeric. Strength of lines.}

\item{smooth}{a numeric (integer). Smoothness of image texture.}

\item{gain}{a numeric between 0 and 1. Can be used to reduce noise in dim regions.}

\item{contrast}{a numeric (integer). Adjusts the image contrast.}

\item{shadow}{a numeric between 0 and 1}

\item{max.size}{maximum image resolution (width or height) of the output image}
}
\value{
an image.
}
\description{
Apply the sketch effect on an image
}
\examples{
im = sketch(face)
plot(im)

\dontrun{
im = im_load("path/to/your/image.jpg")
plot(im)
}
}
