% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_imp_col.R
\name{mean_imp_col}
\alias{mean_imp_col}
\title{Column Mean Imputation}
\usage{
mean_imp_col(obj, subset = NULL)
}
\arguments{
\item{obj}{A numeric matrix with \strong{samples in rows} and \strong{features in columns}.}

\item{subset}{Character vector of column names or integer vector of column
indices specifying which columns to impute.}
}
\value{
A numeric matrix of the same dimensions as \code{obj} with missing values
in the specified columns replaced by column means.
}
\description{
Imputes missing values in a matrix by replacing them with the mean of their
respective columns.
}
\details{
This function calculates the mean for each column excluding missing values and
replaces all missing values in that column with the computed mean.

The \code{subset} parameter allows for imputation of only specific columns.
}
\examples{
# Create example matrix with missing values
mat <- matrix(c(1, 2, NA, 4, 5, 6, NA, 8, 9), nrow = 3)
colnames(mat) <- c("A", "B", "C")
mat

# Impute missing values with column means
imputed_mat <- mean_imp_col(mat)
imputed_mat

# Impute only specific columns by name
imputed_subset <- mean_imp_col(mat, subset = c("A", "C"))
imputed_subset

# Impute only specific columns by index
imputed_idx <- mean_imp_col(mat, subset = c(1, 3))
imputed_idx
}
