% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Levenetestsms.mv.R
\name{Levenetestsms.mv}
\alias{Levenetestsms.mv}
\title{Robust Levene's Tests for the Comparison of Variation of m Samples in Multivariate Data}
\usage{
Levenetestsms.mv(x, group, var.equal = FALSE, P.adjust = "none")
}
\arguments{
\item{x}{a data frame containing a factor with \emph{m} levels and \emph{p}
response variables.}

\item{group}{a factor with \emph{m} levels defining samples. It must be one
of the columns in \code{x}.}

\item{var.equal}{a logical variable indicating whether to treat the \emph{m}
variances of absolute deviations around medians (the variances of the measure
of variation among samples!) as being equal for the One-Way ANOVAs. If
\code{TRUE} then a simple F test for the equality of means is performed. If
\code{FALSE} the Welch (1951) approximation to the degrees of freedom is
used, as implemented in \code{\link[stats]{oneway.test}}.}

\item{P.adjust}{p-value correction method of univariate Levene's tests
(One-Way ANOVAs), a character string. Can be abbreviated. See 'Details'.}
}
\value{
Returns an list of class \code{"Levenetestsms.mv"}, a list
containing the following components:
\tabular{lllllllllllllllll}{
\code{ name} \tab A character string describing the function. \cr
\code{medians} \tab A \eqn{m \times p} matrix; the cell
(\emph{m},\emph{p}) contains the median of the \emph{p}-th response in
sample \emph{m}. \cr
\code{absdev_medians} \tab A list containing \emph{m} data frames, one
data frame for each level of \code{group}, and each data frame having
\emph{p} columns containing the absolute deviations around the \emph{m}-th
sample median. \cr
\code{df_absdev} \tab A data frame containing the absolute deviations
around medians, seen as a compact version of \code{absdev_medians}. \cr
\code{means_absdev} \tab A \eqn{m \times p} matrix; the cell
(\emph{m},\emph{p}) contains the mean absolute deviation around the median
of the \emph{p}-th response in sample \emph{m}. \cr
\code{vars_absdev} \tab A \eqn{m \times p} matrix; the cell
(\emph{m},\emph{p}) contains the variance of absolute deviations around
the median of the \emph{p}-th response in sample \emph{m}. \cr
\code{OneWayANOVAs} \tab A list containing the results of the \emph{p}
tests for equal means of absolute deviations around medians in a one-way
layout. Each element in the list is basically the result of
\code{\link[stats]{oneway.test}}, but the p-values have been possibly
recomputed as a consequence of the \code{P.adjust} method chosen. \cr
\code{ANOVATables} \tab A list containing \emph{p} analysis of variance
tables produced by \code{anova.lm}, each table corresponding to a one-way
analysis of variance for the comparison of \emph{m}-samples on the
\emph{p}-th response variable. Each element in the list is basically the
result of \code{\link[stats]{anova.lm}}, but the p-values have been
possibly recomputed as a consequence of 1) the \code{P.adjust} method
chosen, and/or 2) the assumption of equal variance of absolute deviations
around medians is \code{FALSE}. \cr
\code{var.equal} \tab A logical variable indicating whether the two
variances were treated as being equal \code{TRUE} or not \code{FALSE}.
\cr
\code{P.adjust} \tab A character string indicating the correction method
chosen. \cr
\code{Eff_sizes} \tab A list of length \emph{p} containing four effect
size measures for an F-test in one-way ANOVA, and their respective 95\%
confidence intervals. Those measures are \eqn{\eta^2}, \eqn{\omega^2},
\eqn{\epsilon^2} and Cohen's \emph{f}, as implemented in the
\pkg{effectsize} package (Ben-Shachar et al. 2020). When
\code{var.equal = FALSE} these effect sizes are approximations.\cr
\code{OWM_absdev} \tab A list of class "\code{manova}" containing  the
results of the One-Way MANOVA applied to the absolute deviations around
medians, i.e., the multivariate Levene's test. \cr
\code{group} \tab A character string specifying the name of the
\emph{m}-level factor defining samples. \cr
\code{levels.group} \tab A vector of length \emph{m} showing the levels in
factor \code{group}. \cr
\code{variables} \tab A vector of length \emph{p} showing the names of
response variables. \cr
\code{data.name} \tab A character string giving the name of the data. \cr
\code{data} \tab The data frame analyzed.  \cr
}

The extractor function \code{\link[smsets]{print.Levenetestsms.mv}} returns
an annotated output of the univariate Levene tests and, optionally, the
multivariate Levene's test.
}
\description{
Performs Levene's tests for \emph{m} samples on \emph{p} responses, based on
(univariate) One-Way ANOVAs and One-Way MANOVAs applied to absolute
differences around medians. Significance levels of the univariate tests of
variation can be corrected using any of the adjustment methods for multiple
comparisons offered by \code{\link[stats]{p.adjust}}. Effects sizes are also
computed with respect to the One-Way ANOVAs.
}
\details{
This function focuses on robust Levene's tests, both univariate and
multivariate, for the comparison of variation among \emph{m} samples in
multivariate data. These tests can be chosen as alternatives to Box's test
which is sensitive to deviations from normality. The application of
Levene's test one variable at a time from a set of \emph{p} variables can be
computed by repeating \emph{p} times \pkg{car}'s package function
\code{\link[car]{leveneTest}} (Fox and Weisberg 2019), when
\code{center = median}. However, there are \emph{p} univariate Levene's tests
possible, each one consisting of one-way ANOVAs applied to the absolute
deviations around medians. Therefore, the p-values produced in the ANOVAs can
be subject to corrections for multiple testing, depending on the number of
response variables analyzed. The methods implemented in \code{P.adjust} are
the same as those contained in the \code{p.adjust.methods}:
\code{"bonferroni"}, \code{"holm"}, \code{"hochberg"}, \code{"hommel"},
\code{"BH"}, (Benjamini-Hochberg) or its alias \code{"fdr"} (False Discovery
Rate), and \code{"BY"} (Benjamini & Yekutieli). The default pass-through
option (\code{"none"}) is also included. Four measures of effect size are
also computed with respect to the univariate  F tests, which are interpreted
as effect sizes of variation among samples. User-friendly summaries of all
analyses (including the multivariate Levene's test) can be invoked using the
\code{print} method for this function.
}
\examples{
data(skulls)
res.Levenems.mv <- Levenetestsms.mv(skulls, Period, var.equal = TRUE,
                                    P.adjust = "bonferroni")
res.Levenems.mv

}
\references{
Ben-Shachar, M., Lüdecke, D., and Makowski, D. (2020). effectsize: Estimation
of Effect Size Indices and Standardized Parameters. \emph{Journal of Open
Source Software}, 5(56), 2815. doi: 10.21105/joss.02815

Fox, J., and Weisberg, S. (2019). \emph{An R Companion to Applied Regression},
Third edition. Sage, Thousand Oaks CA. https://www.john-fox.ca/Companion/.

Manly, B.F.J., Navarro Alberto, J.A. and Gerow, K. (2024)
\emph{Multivariate Statistical Methods. A Primer}. 5th Edn.
Chapman and Hall/CRC.

Welch, B.L. (1951). On the comparison of several mean values: an alternative
approach. \emph{Biometrika}, 38, 330-336. doi:10.2307/2332579.
}
\author{
Jorge Navarro Alberto, \email{ganava4@gmail.com}
}
