% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.summary.table.R
\name{model.summary.table}
\alias{model.summary.table}
\title{Generate a Summary Table for a Linear Model}
\usage{
model.summary.table(model, caption, latex = TRUE)
}
\arguments{
\item{model}{A linear model object (typically the result of `lm()`).}

\item{caption}{A character string to be used as the caption for the table.}

\item{latex}{Logical; if `TRUE` (default), returns a LaTeX-formatted table using `kableExtra`.
If `FALSE`, prints plain-text summary tables to the console.}
}
\value{
If `latex = TRUE`, returns a LaTeX-formatted `kableExtra` table object.
        If `latex = FALSE`, prints formatted summary tables to the console and returns the underlying data frame.
}
\description{
This function creates a summary table for a linear model, including estimated
coefficients, standard errors, p-values with significance codes, and model
statistics such as MSE and R-squared. The table can be output as either
LaTeX (for PDF reports) or plain text (for console viewing).
}
\examples{
# Fit a linear model
model <- lm(mpg ~ wt + hp, data = mtcars)

# Print a plain-text version to the console
model.summary.table(model, caption = "Linear Model Summary", latex = FALSE)

}
