% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kramerSimpson.R
\name{kramerSimpsonScores}
\alias{kramerSimpsonScores}
\alias{kramerSimpsonRanking}
\title{Kramer-Simpson-like method}
\usage{
kramerSimpsonScores(powerRelation, elements = powerRelation$elements)

kramerSimpsonRanking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{elements}{Vector of elements of which to calculate their scores.
By default, the scores of all elements in \code{powerRelation$elements} are considered.}
}
\value{
Score function returns a vector of type \code{KramerSimpsonScores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified). Higher scoring elements are ranked higher.

Ranking function returns corresponding \code{\link{SocialRanking}} object.
}
\description{
Calculate the Kramer-Simpson-like scores.
Higher scores are better.

\code{kramerSimpsonRanking()} returns the corresponding ranking.
}
\details{
Inspired by the Kramer-Simpson method of social choice theory \insertCite{1969Simpson}{socialranking} \insertCite{1975Kramer}{socialranking}, the \emph{Kramer-Simpson-like}
method compares each element against all other elements using the CP-Majority rule.

For a given element \eqn{i}{i}, calculate the \code{\link[=cpMajorityComparisonScore]{cpMajorityComparisonScore()}}
against all elements \eqn{j}{j}, \eqn{d_{ji}(\succsim)}{d_ji(>=)} (notice that \eqn{i}{i} and
\eqn{j}{j} are in reverse order).
\eqn{-\max_{j \in N \setminus \lbrace i \rbrace}(d_{ji}(\succsim))}{-max_{j in N}(d_ji(>=))} then
determines the final score, where higher scoring elements are ranked higher (notice the negative symbol in front of the \eqn{\max}{max} statement).

The implementation slightly differs from the original definition in \insertRef{2021Manipulability}{socialranking}.
While the ranking solution itself is the same, the scores for this package are intentionally multiplied by -1,
as this significantly improves performance when sorting the elements, as well as making simple comparisons between elements more logical to the user.
}
\examples{
# 2 > (1 ~ 3) > 12 > (13 ~ 23) > {} > 123
pr <- as.PowerRelation("2 > (1~3) > 12 > (13~23) > {} > 123")

# get scores for all elements
# cpMajorityComparisonScore(pr, 2, 1, strictly = TRUE)[1] = 1
# cpMajorityComparisonScore(pr, 3, 1, strictly = TRUE)[1] = 0
# therefore the Kramer-Simpson-Score for element
# `1` = -max(0, 1) = -1
#
# Score analogous for the other elements
# `2` = 0
# `3` = -2
kramerSimpsonScores(pr)

# get scores for two elements
# `1` = 1
# `3` = 2
kramerSimpsonScores(pr, c(1,3))

# or single element
# result is still a list
kramerSimpsonScores(pr, 2)

# 2 > 1 > 3
kramerSimpsonRanking(pr)

}
\references{
\insertRef{2021Manipulability}{socialranking}

\insertRef{1969Simpson}{socialranking}

\insertRef{1975Kramer}{socialranking}
}
\seealso{
Other CP-majority based functions: 
\code{\link{copelandScores}()},
\code{\link{cpMajorityComparison}()}

Other ranking solution functions: 
\code{\link{L1Scores}()},
\code{\link{L2Scores}()},
\code{\link{LPSScores}()},
\code{\link{LPScores}()},
\code{\link{copelandScores}()},
\code{\link{cumulativeScores}()},
\code{\link{lexcelScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{CP-majority based functions}
\concept{ranking solution functions}
