% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitiveClosure.R
\name{transitiveClosure}
\alias{transitiveClosure}
\title{Transitive Closure}
\usage{
transitiveClosure(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}
}
\value{
\code{\link{PowerRelation}} object with no cycles.
}
\description{
Apply transitive closure over power relation that has cycles.
}
\details{
A power relation is a binary relationship between coalitions that is transitive.
For coalitions \eqn{a, b, c \in 2^N}{a, b, c in 2^N}, this means that if \eqn{a \succ b}{a > b} and
\eqn{b \succ c}{b > c}, then \eqn{a \succ c}{a > c}.

A power relation with cycles is not transitive. A transitive closure over a power relation removes all cycles and turns it into a
transitive relation, placing all coalitions within a cycle in the same equivalence class.
If \eqn{a \succ b \succ a}{a > b > a}, from the symmetric definition in \code{\link[=PowerRelation]{PowerRelation()}} we
therefore assume that \eqn{a \sim b}{a ~ b}. Similarly, if
\eqn{a \succ b_1 \succ b_2 \succ \dots \succ b_n \succ a}{a > b_1 > b_2 > ... > b_n > a}, the transitive closure turns it into
\eqn{a \sim b_1 \sim b_2 \sim \dots \sim b_n}{a ~ b_1 ~ b_2 ~ ... ~ b_n}.

\code{transitiveClosure()} transforms a \code{\link{PowerRelation}} object with cycles into a \code{PowerRelation} object without cycles.
As described above, all coalitions within a cycle then are put into the same equivalence class
and all duplicate coalitions are removed.
}
\examples{
pr <- as.PowerRelation("1 > 2")

# nothing changes
transitiveClosure(pr)


pr <- suppressWarnings(as.PowerRelation("1 > 2 > 1"))

# 1 ~ 2
transitiveClosure(pr)


pr <- suppressWarnings(
  as.PowerRelation("1 > 3 > 1 > 2 > 23 > 2")
)

# 1 > 3 > 1 > 2 > 23 > 2 =>
# 1 ~ 3 > 2 ~ 23
transitiveClosure(pr)

}
