% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_KSSL.R
\name{filter_geochem}
\alias{filter_geochem}
\title{Filter KSSL Geochemical Table}
\usage{
filter_geochem(
  geochem,
  columns = NULL,
  prep_code = NULL,
  major_element_method = NULL,
  trace_element_method = NULL
)
}
\arguments{
\item{geochem}{geochemical data, as returned by fetchKSSL}

\item{columns}{Column name(s) to include in result}

\item{prep_code}{Character vector of prep code(s) to include in result.}

\item{major_element_method}{Character vector of major element method(s) to include in result.}

\item{trace_element_method}{Character vector of trace element method(s) to include in result.}
}
\value{
A data.frame, subset according to the constraints specified in arguments.
}
\description{
A function to subset KSSL "geochem" / elemental analysis result table to obtain rows/columns based on: column name, preparation code, major / trace element method.
}
\author{
Andrew G. Brown.
}
