% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{download_naip_for_las}
\alias{download_naip_for_las}
\title{Download NAIP Imagery for LiDAR Extent}
\usage{
download_naip_for_las(
  las,
  output_path = NULL,
  year_range = c("2018-01-01", "2023-12-31"),
  buffer = 0,
  overwrite = FALSE
)
}
\arguments{
\item{las}{A LAS object or path to a LAS/LAZ file}

\item{output_path}{Character string specifying output file path for the downloaded imagery.
If NULL, creates a file named based on the input LAS file.}

\item{year_range}{Character vector of length 2 specifying date range for NAIP imagery
in format c("YYYY-MM-DD", "YYYY-MM-DD"). Default is c("2018-01-01", "2023-12-31").}

\item{buffer}{Numeric value to buffer the extent in meters. Default is 0.}

\item{overwrite}{Logical, whether to overwrite existing output file. Default is FALSE.}
}
\value{
Character string of the output file path, or NULL if download failed.
}
\description{
Downloads NAIP (National Agriculture Imagery Program) imagery from
Microsoft Planetary Computer STAC API for the extent of a LAS/LAZ point cloud.
}
\details{
This function queries the Microsoft Planetary Computer STAC API to find and download
NAIP imagery that overlaps with the extent of the input LAS file. The imagery is
automatically cropped to match the LiDAR extent and saved as a GeoTIFF.

NAIP imagery is typically 4-band (RGB + NIR) with 0.6m or 1m resolution, collected
annually or biannually across the continental United States.

Requires the \code{rstac} package for STAC API access.
}
\examples{
\donttest{
# Load example LAS file
LASfile <- system.file("extdata", "ALS_Clip.laz", package="spanner")
las <- readLAS(LASfile)

# Download NAIP for a LAS file
naip_path <- download_naip_for_las(las, output_path = tempfile(fileext = ".tif"))

# Download with buffer and specific year range
naip_path2 <- download_naip_for_las(las, buffer = 10,
                                    output_path = tempfile(fileext = ".tif"),
                                    year_range = c("2020-01-01", "2023-12-31"))

# Then use with colorize_las
las_colored <- colorize_las(las, method = "rgb", raster_path = naip_path)
}

}
