% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{simepleStack}
\alias{simepleStack}
\title{A simple stack structure and methods}
\value{
an R6 class object
}
\description{
A simple stack data structure in R, with supporting of assiocated
methods, like push, pop and others.
}
\examples{
my_stack <- simepleStack$new()
# check length
my_stack$len()
# add some thing
my_stack$push(list(1, 2, 3))
# print current stack
str(my_stack$get())
# check length
my_stack$len()
# add before the current first
my_stack$push(list(0), after = 0)
# print current stack
str(my_stack$get())
# pop one item
my_stack$pop()
# print current stack
str(my_stack$get())
# pop one item from the tail
my_stack$pop(tail = TRUE)
# print current stack
str(my_stack$get())
# pop more than one items
my_stack$pop(2)
# print current stack
str(my_stack$get()) # nothing left
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-simepleStack-new}{\code{simepleStack$new()}}
\item \href{#method-simepleStack-len}{\code{simepleStack$len()}}
\item \href{#method-simepleStack-get}{\code{simepleStack$get()}}
\item \href{#method-simepleStack-clear}{\code{simepleStack$clear()}}
\item \href{#method-simepleStack-push}{\code{simepleStack$push()}}
\item \href{#method-simepleStack-pop}{\code{simepleStack$pop()}}
\item \href{#method-simepleStack-clone}{\code{simepleStack$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-new"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-new}{}}}
\subsection{Method \code{new()}}{
initialize a new object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$new(items = list(), limit = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{list, list of items to add to the initial stack}

\item{\code{limit}}{int, how many items can be pushed to the stack, default is
unlimited.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-len"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-len}{}}}
\subsection{Method \code{len()}}{
returns current length of the stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$len()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-get"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-get}{}}}
\subsection{Method \code{get()}}{
returns the full current stack of **all items**
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$get()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-clear"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-clear}{}}}
\subsection{Method \code{clear()}}{
remove **all items** in current stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-push"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-push}{}}}
\subsection{Method \code{push()}}{
add item(s) to the stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$push(items, after = self$len())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{list, list of items to add to the stack}

\item{\code{after}}{int, which position to push items after, default is after
the current last item. 0 will be before the first item.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-pop"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-pop}{}}}
\subsection{Method \code{pop()}}{
remove item(s) from the stack and return as results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$pop(len = 1, tail = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{len}}{int, how many items to pop from stack, default is 1 item a time.}

\item{\code{tail}}{bool, to pop in the reverse order (from the last item)? Default
is `FALSE`, pop from the top (first item).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-simepleStack-clone"></a>}}
\if{latex}{\out{\hypertarget{method-simepleStack-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simepleStack$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
