% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srvyr.r
\docType{package}
\name{srvyr}
\alias{srvyr-package}
\alias{srvyr}
\title{srvyr: A package for 'dplyr'-Like Syntax for Summary Statistics of Survey Data.}
\description{
The srvyr package provides a new way of calculating summary statistics
on survey data, based on the dplyr package. There are three stages to using
srvyr functions, creating a survey object, manipulating the data, and
calculating survey statistics.
}
\section{Functions to create a survey object}{

\code{\link{as_survey_design}}, \code{\link{as_survey_rep}},
and \code{\link{as_survey_twophase}} are used to create surveys based on
a data.frame and design variables, replicate weights or two phase design
respectively. Each is based on a function in the survey package
(\code{\link[survey]{svydesign}}, \code{\link[survey]{svrepdesign}},
\code{\link[survey]{twophase}}), and it is easy to modify code that uses
the survey package so that it works with the srvyr package. See
\code{vignette("srvyr_vs_survey")} for more details.

The function \code{\link{as_survey}} will choose between the other three
functions based on the arguments given to save some typing.
}

\section{Functions to manipulate data in a survey object}{

Once you've created a survey object, you can manipulate the data as you would
using dplyr with a data.frame. \code{\link{mutate}} modifies or creates a variable,
\code{\link{select}} and \code{\link{rename}} select or rename variables, and
\code{\link{filter}} keeps certain observations.

Note that \code{arrange} and two table verbs such as \code{bind_rows},
\code{bind_cols}, or any of the joins are not usable on survey objects
because they might require modifications to the definition of your survey. If
you need to use these functions, you should do so before you convert the
data.frame to a survey object.
}

\section{Functions to summarize a survey object}{

Now that you have your data set up correctly, you can calculate summary
statistics. To get the statistic over the whole population, use
\code{\link{summarise}}, or to calculate it over a set of groups, use
\code{\link{group_by}} first.

You can calculate the mean, (with \code{\link{survey_mean}}), the total
(\code{\link{survey_total}}), the quantile (\code{\link{survey_quantile}}),
or a ratio (\code{\link{survey_ratio}}). By default, srvyr will return the
statistic and the standard error around it in a data.frame, but with the
\code{vartype} parameter, you can also get a confidence interval ("ci"),
variance ("var"), or coefficient of variation ("cv").

Within summarise, you can also use \code{\link{unweighted}}, which calculates
a function without taking into consideration the survey weighting.
}

\seealso{
Useful links:
\itemize{
  \item \url{http://gdfe.co/srvyr/}
  \item \url{https://github.com/gergness/srvyr/}
  \item Report bugs at \url{https://github.com/gergness/srvyr/issues}
}

}
\author{
\strong{Maintainer}: Greg Freedman Ellis \email{greg.freedman@gmail.com}

Authors:
\itemize{
  \item Ben Schneider [contributor]
}

Other contributors:
\itemize{
  \item Thomas Lumley [contributor]
  \item Tomasz Żółtak [contributor]
  \item Pavel N. Krivitsky \email{pavel@statnet.org} [contributor]
}

}
