% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.cqv}
\alias{ci.cqv}
\title{Confidence interval for a coefficient of quartile variation}
\usage{
ci.cqv(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated coefficient of quartile variation
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a population coefficient
of quartile variation which is defined as (Q3 - Q1)/(Q3 + Q1) where Q1 is the
25th percentile and Q3 is the 75th percentile. The coefficient of quartile
variation assumes ratio-scale scores and is a robust alternative to the
coefficient of variation (see \link[statpsych]{ci.cv}). The 25th and 75th
percentiles are computed using the type = 2 method (SAS default).

For more details, see Section 1.27 of Bonett (2021, Volume 1)
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40,
       20, 10, 0, 20, 50)
ci.cqv(.05, y)

# Should return:
# Estimate        SE        LL       UL
#      0.5 0.1552485 0.2617885 0.8841821


}
\references{
\insertRef{Bonett2006c}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
