% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evaluate_variable_arguments}
\alias{evaluate_variable_arguments}
\title{Evaluate Variable Arguments with NSE Support}
\usage{
evaluate_variable_arguments(
  arg_expr,
  arg_name = "arg",
  data = NULL,
  calling_env = parent.frame(),
  func_name = "function",
  allow_null = FALSE
)
}
\arguments{
\item{arg_expr}{Unevaluated expression (from match.call() or substitute())}

\item{arg_name}{Character string. Name of the argument (for error messages)}

\item{data}{Optional data frame to look up columns}

\item{calling_env}{Environment to evaluate symbols if data is NULL}

\item{func_name}{Character string. Name of calling function (for error messages)}

\item{allow_null}{Logical. If TRUE, NULL is a valid input. Default FALSE.}
}
\value{
A list with:
\itemize{
  \item \code{value}: The actual data (vector, formula, or NULL)
  \item \code{name}: Clean name for labels (e.g., "DV1")
  \item \code{name_raw}: Raw name for error messages (e.g., "df$DV1")
  \item \code{was_symbol}: Logical. TRUE if input was an unquoted name
}
}
\description{
Resolves bare symbols (unquoted names) or quoted strings to actual data,
either from a data frame or the calling environment. This enables both
\code{plot_density(DV1, data=df)} and \code{plot_density("DV1", data=df)}
to work identically.
}
\keyword{internal}
