% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plot density of a variable, optionally by another variable}
\usage{
plot_density(
  formula,
  y = NULL,
  data = NULL,
  order = NULL,
  show_means = TRUE,
  ...
)
}
\arguments{
\item{formula}{Either the single variable name \code{y} or a formula like \code{y ~ x}.
Alternatively, pass a single vector for a simple density plot.}

\item{y}{An optional second vector to compare with \code{formula}. When provided,
creates a comparison plot of two variables. This allows syntax like 
\code{plot_density(y1, y2)} to compare two vectors.}

\item{data}{An optional data frame containing the variables in the formula.}

\item{order}{Controls the order in which groups appear in the plot and legend. 
Use \code{-1} to reverse the default order. Alternatively, provide a vector specifying
the exact order (e.g., \code{c("B", "A", "C")}). If \code{NULL} (default), groups are 
ordered by their factor levels (if the grouping variable is a factor) or sorted 
alphabetically/numerically. Only applies when using grouped plots.}

\item{show_means}{Logical. If TRUE (default), shows points at means.}

\item{...}{Additional arguments passed to plotting functions.}
}
\value{
Invisibly returns a list with the following element:
  \describe{
    \item{densities}{A named list of density objects (class \code{"density"}), 
      one for each group. Each density object contains \code{x} (evaluation points), 
      \code{y} (density estimates), \code{bw} (bandwidth), and other components 
      as returned by \code{\link[stats]{density}}. If no grouping variable is 
      provided, the list contains a single element named \code{"all"}.}
  }
  The function is primarily called for its side effect of creating a plot.
}
\description{
Plots the distribution of a variable by group, simply: \code{plot_density(y ~ x)}
}
\details{
Plot parameters like
\code{col}, \code{lwd}, \code{lty}, and \code{pch} can be specified as:
\itemize{
  \item A single value: applied to all groups
  \item A vector: applied to groups in order of unique \code{group} values
}
}
\examples{
# Basic usage with formula syntax (no grouping)
y <- rnorm(100)
plot_density(y)

# With grouping variable
group <- rep(c("A", "B", "C"), c(30, 40, 30))
plot_density(y ~ group)

# With custom colors (scalar - same for all)
plot_density(y ~ group, col = "blue")

# With custom colors (vector - different for each group)
plot_density(y ~ group, col = c("red", "green", "blue"))

# Multiple parameters
plot_density(y ~ group, col = c("red", "green", "blue"), lwd = c(1, 2, 3))

# With line type
plot_density(y ~ group, col = c("red", "green", "blue"), lty = c(1, 2, 3), lwd = 2)

# Using data frame
df <- data.frame(value = rnorm(100), group = rep(c("A", "B"), 50))
plot_density(value ~ group, data = df)
plot_density(value ~ group, data = df, col = c("red", "blue"))

# Compare two vectors
y1 <- rnorm(50)
y2 <- rnorm(50, mean = 1)
plot_density(y1, y2)

}
