% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t.test2.R
\name{t.test2}
\alias{t.test2}
\title{Enhanced alternative to t.test()}
\arguments{
\item{...}{Arguments passed to \code{\link[stats]{t.test}}}
}
\value{
A data frame with class \code{c("t.test2", "data.frame")} containing 
  a single row with the following columns:
  \describe{
    \item{mean columns}{One or two columns containing group means, named after 
      the input variables (e.g., \code{men}, \code{women}) or \code{Group 1}, 
      \code{Group 2} for long names.}
    \item{diff column}{For two-sample tests, the difference between means 
      (e.g., \code{men-women}).}
    \item{ci}{The confidence level as a string (e.g., "95 percent").}
    \item{ci.L, ci.H}{Lower and upper bounds of the confidence interval.}
    \item{t}{The t-statistic.}
    \item{df}{Degrees of freedom.}
    \item{p.value}{The p-value.}
    \item{N columns}{Sample sizes, named \code{N(group1)}, \code{N(group2)} or 
      \code{N1}, \code{N2}. For paired tests, a single \code{N} column.}
    \item{correlation}{For paired tests only, the correlation between pairs.}
  }
  Attributes store additional information including missing value counts and 
  test type (one-sample, two-sample, paired, Welch vs. Student).
}
\description{
The basic t-test function in R, \code{\link[stats]{t.test}}, does not report 
 the observed difference of means, does not stipulate which mean
 is subtracted from which (i.e., whether it computed A-B or B-A), and
 presents the test results on the console in a verbose unorganized 
 paragraph of text. \code{t.test2} improves on all those counts, and 
 in addition, it reports the number of observations per group and if any observations 
 are missing it issues a warning. It returns a dataframe instead of a list.
}
\examples{
# Two-sample t-test
men <- rnorm(100, mean = 5, sd = 1)
women <- rnorm(100, mean = 4.8, sd = 1)
t.test2(men, women)

# Paired t-test
x <- rnorm(50, mean = 5, sd = 1)
y <- rnorm(50, mean = 5.2, sd = 1)
t.test2(x, y, paired = TRUE)

# One-sample t-test
data <- rnorm(100, mean = 5, sd = 1)
t.test2(data, mu = 0)

# Formula syntax
data <- data.frame(y = rnorm(100), group = rep(c("A", "B"), 50))
t.test2(y ~ group, data = data)

}
