% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-conditions.R
\name{.stop_cant_coerce}
\alias{.stop_cant_coerce}
\title{Abort with a standardized "can't coerce" message}
\usage{
.stop_cant_coerce(
  from_class,
  to_class,
  x_arg,
  call,
  additional_msg = NULL,
  message_env = call,
  parent = NULL,
  ...
)
}
\arguments{
\item{from_class}{\verb{(length-1 character)} The class of the object that failed
coercion.}

\item{to_class}{\verb{(length-1 character)} The target class for the coercion.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{additional_msg}{\verb{(length-1 character)} Optional, additional
cli-formatted messages.}

\item{message_env}{(\code{environment}) The execution environment to use to
evaluate variables in error messages.}

\item{parent}{A parent condition, as you might create during a
\code{\link[rlang:try_fetch]{rlang::try_fetch()}}. See \code{\link[rlang:abort]{rlang::abort()}} for additional information.}

\item{...}{Additional parameters passed to \code{\link[cli:cli_abort]{cli::cli_abort()}} and on to
\code{\link[rlang:abort]{rlang::abort()}}.}
}
\value{
This function is called for its side effect of throwing an error and
does not return a value.
}
\description{
Abort with a standardized "can't coerce" message
}
\keyword{internal}
