% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.coxtp.R, R/confint.coxtv.R
\name{confint.coxtp}
\alias{confint.coxtp}
\alias{confint.coxtv}
\title{get confidence intervals of time-varying coefficients from a fitted object}
\usage{
\method{confint}{coxtp}(object, parm, level = 0.95, time, ...)

\method{confint}{coxtv}(object, parm, level = 0.95, time, ...)
}
\arguments{
\item{object}{fitted \code{"coxtv"} model.}

\item{parm}{the names of parameters.}

\item{level}{the confidence level. The default value is 0.95.}

\item{time}{the time points for which the confidence intervals to be estimated.
The default value is the unique observed event times in the dataset fitting the time-varying effects model.}

\item{\dots}{other parameters to function}
}
\value{
A list where each element corresponds to one of the parameters specified in \code{parm}. Each element in the
list is a matrix, with rows corresponding to the specified \code{time} points and three columns representing the
estimated values of the parameter, and the lower and upper bounds of the confidence interval at the specified
confidence \code{level}. The length of the list is determined by the number of parameters in \code{parm}, and each matrix
has rows equal to the number of specified \code{time} points.

A list where each element corresponds to one of the parameters specified in \code{parm}. Each element in the
list is a matrix, with rows corresponding to the specified \code{time} points and three columns representing the
estimated values of the parameter, and the lower and upper bounds of the confidence interval at the specified
confidence \code{level}. The length of the list is determined by the number of parameters in \code{parm}, and each matrix
has rows equal to the number of specified \code{time} points.
}
\description{
Get confidence intervals of time-varying coefficients from a fitted \code{coxtv} or \code{coxtp} object.
}
\examples{
\donttest{
data(ExampleData)
z <- ExampleData$z
time <- ExampleData$time
event <- ExampleData$event
fit <- coxtp(event = event, z = z, time = time)
IC  <- IC(fit)
confint(IC$model.mAIC)
}

data(ExampleData)
z <- ExampleData$z
time <- ExampleData$time
event <- ExampleData$event
fit <- coxtv(event = event, z = z, time = time)
confint <- confint(fit)

}
