% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_copy.R
\name{var_copy}
\alias{var_copy}
\title{Copy a variable}
\usage{
var_copy(newvr, vr)
}
\arguments{
\item{newvr}{name of the new variable to be created}

\item{vr}{variable}
}
\value{
Survey object
}
\description{
Create a new variable that is a copy of another variable. You can modify the copy,
while the original remains unchanged. See examples.
}
\examples{
set_survey(namcs2019sv)
var_copy("Age group", "AGER")
var_collapse("Age group", "65+", c("65-74 years", "75 years and over"))
var_collapse("Age group", "25-64", c("25-44 years", "45-64 years"))
tab("AGER", "Age group")
}
\seealso{
Other variables: 
\code{\link{var_all}()},
\code{\link{var_any}()},
\code{\link{var_case}()},
\code{\link{var_collapse}()},
\code{\link{var_cross}()},
\code{\link{var_cut}()},
\code{\link{var_not}()}
}
\concept{variables}
