% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{jury_votes}
\alias{jury_votes}
\title{Jury votes}
\format{
This data frame contains the following columns:
\describe{
\item{\code{version}}{Country code for the version of the show}
\item{\code{version_season}}{Version season key}
\item{\code{season}}{The season number}
\item{\code{castaway}}{Name of the castaway}
\item{\code{finalist}}{The finalists for which a vote can be placed}
\item{\code{vote}}{Vote. 0-1 variable for easy summation}
\item{\code{castaway_id}}{ID of the castaway (primary key). Consistent across seasons and name changes e.g. Amber Brkich / Amber Mariano. The first two letters reference the country of the version played e.g. US, AU.}
\item{\code{finalist_id}}{The ID of the finalist for which a vote can be placed. Consistent with castaway ID}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
jury_votes
}
\description{
A dataset containing details on the final jury votes to determine the winner for each season
}
\examples{
library(dplyr)
jury_votes \%>\%
  filter(season == 40) \%>\%
  group_by(finalist) \%>\%
  summarise(votes = sum(vote))
}
\keyword{datasets}
