# Copyright 2010-2020 Meik Michalke <meik.michalke@hhu.de>
#
# This file is part of the R package sylly.
#
# sylly is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# sylly is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with sylly.  If not, see <http://www.gnu.org/licenses/>.


#' Getter/setter methods for sylly objects
#' 
#' These methods should be used to get or set values of hyphenated text objects
#' generated by functions like \code{hyphen()}.
#' 
#' \describe{
#'   \item{\code{describe()} }{returns the \code{desc} slot.}
#'   \item{\code{language()} }{returns the \code{lang} slot.}
#'   \item{\code{hyphenText()} }{returns the \code{hyphen} slot from objects of class \code{kRp.hyphen}.}
#'   \item{\code{[}/\code{[[} }{Can be used as a shortcut to index the results of \code{hyphenText()}.}
#' }
#' @param obj An object of class \code{\link[sylly:kRp.hyphen-class]{kRp.hyphen}}.
#' @param ... Additional arguments as defined by respective methods.
#' @docType methods
#' @export
#' @rdname kRp.hyphen-methods
setGeneric("describe", function(obj, ...) standardGeneric("describe"))

#' @export
#' @docType methods
#' @rdname kRp.hyphen-methods
#' @examples
#' \dontrun{
#' hyphenText(hyphenated.txt)
#' }
#' @aliases
#'    describe,kRp.hyphen-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("describe",
  signature=signature(obj="kRp.hyphen"),
  function (obj){
    result <- slot(obj, name="desc")
    return(result)
  }
)

#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
setGeneric("describe<-", function(obj, ..., value) standardGeneric("describe<-"))
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    describe<-,kRp.hyphen-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("describe<-",
  signature=signature(obj="kRp.hyphen"),
  function (obj, ..., value){
    slot(obj, name="desc") <- value
    return(obj)
  }
)

#' @export
#' @docType methods
#' @rdname kRp.hyphen-methods
setGeneric("language", function(obj) standardGeneric("language"))
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    language,kRp.hyphen-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("language",
  signature=signature(obj="kRp.hyphen"),
  function (obj){
    result <- slot(obj, name="lang")
    return(result)
  }
)

#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
setGeneric("language<-", function(obj, value) standardGeneric("language<-"))
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    language<-,kRp.hyphen-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("language<-",
  signature=signature(obj="kRp.hyphen"),
  function (obj, value){
    slot(obj, name="lang") <- value
    return(obj)
  }
)

#' @export
#' @docType methods
#' @rdname kRp.hyphen-methods
setGeneric("hyphenText", function(obj) standardGeneric("hyphenText"))
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    hyphenText,-methods
#'    hyphenText,kRp.hyphen-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("hyphenText",
  signature=signature(obj="kRp.hyphen"),
  function (obj){
    result <- slot(obj, name="hyphen")
    return(result)
  }
)

#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
setGeneric("hyphenText<-", function(obj, value) standardGeneric("hyphenText<-"))
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    hyphenText<-,-methods
#'    hyphenText<-,kRp.hyphen-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("hyphenText<-",
  signature=signature(obj="kRp.hyphen"),
  function (obj, value){
    slot(obj, name="hyphen") <- value
    return(obj)
  }
)

#' @param x An object of class \code{\link[sylly:kRp.hyphen-class]{kRp.hyphen}}.
#' @param i Row index.
#' @param j Column index.
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    [,-methods
#'    [,kRp.hyphen,ANY,ANY-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("[",
  signature=signature(x="kRp.hyphen"),
  function (x, i, j){
    return(hyphenText(x)[i, j])
  }
)

#' @param value A value to set.
#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    [<-,-methods
#'    [<-,kRp.hyphen,ANY,ANY,ANY-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("[<-",
  signature=signature(x="kRp.hyphen"),
  function (x, i, j, value){
    hyphenText(x)[i, j] <- value
    return(x)
  }
)

#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    [[,-methods
#'    [[,kRp.hyphen,ANY-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("[[",
  signature=signature(x="kRp.hyphen"),
  function (x, i){
    return(hyphenText(x)[[i]])
  }
)

#' @rdname kRp.hyphen-methods
#' @export
#' @docType methods
#' @aliases
#'    [[<-,-methods
#'    [[<-,kRp.hyphen,ANY,ANY-method
#' @include 01_class_02_kRp.hyphen.R
setMethod("[[<-",
  signature=signature(x="kRp.hyphen"),
  function (x, i, value){
    hyphenText(x)[[i]] <- value
    return(x)
  }
)
