% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnn.R
\name{fnn}
\alias{fnn}
\alias{fnn,data.frame-method}
\title{false nearest neighbours}
\usage{
\S4method{fnn}{data.frame}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 2:10,
  tau = 1,
  dist.metric = "L1",
  rt = 10,
  eps = 2,
  threads = length(E)
)
}
\arguments{
\item{data}{observation data.}

\item{target}{name of target variable.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of time lags.}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{rt}{(optional) escape factor.}

\item{eps}{(optional) neighborhood diameter.}

\item{threads}{(optional) number of threads to use.}
}
\value{
A vector
}
\description{
false nearest neighbours
}
\examples{
sim = logistic_map(x = 0.4,y = 0.4,step = 45,beta_xy = 0.5,beta_yx = 0)
fnn(sim,"x",threads = 1)

}
\references{
Kennel M. B., Brown R. and Abarbanel H. D. I., Determining embedding dimension for phase-space reconstruction using a geometrical construction, Phys. Rev. A, Volume 45, 3403 (1992).
}
