% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdPRC-package.R
\docType{package}
\name{tdPRC-package}
\alias{tdPRC-package}
\title{{tdPRC}}
\description{
{Tools for estimating and visualizing, precision-recall curve and the receiver operating characteristic (ROC) curves.
           The area under precision-recall (AUPRC) and area under the ROC curve (AUC) can be compared with statistical tests based on bootstrap standard error.
           Confidence intervals can be computed for AUPRC and AUC.}
}
\section{Abbreviations}{
{ In this package, the following abbreviations are commonly used:
\describe{
 \item{TPR  }{True Positive Rate.}
 \item{FPR  }{False Posetive Rate.}
 \item{PPV  }{Positive Predictive Value.}
 \item{AUPRC  }{Area under the precision-recall curve.}
 \item{ROC  }{The Receiver Operating Characteristic curve.}
 \item{AUC  }{Area under the ROC curve at a given time horizon \code{t}.}
}
}
}

\section{Dataset}{
 {This package comes with a right-censored data set with 312 observations and 4 variables. For details see \code{\link{mayo}}
 }
}

\section{Installing and using}{

     {
   Ensure that your system has an active internet connection, then execute the following command in the R console to install the package:
      \preformatted{
                    install.packages("tdPRC")
      }

   To load the package after installation, use the following command:
     \preformatted{
                    library(tdPRC)
     }
   }
}

\references{
Beran, R. (1981). Nonparametric regression with randomly censored survival data. Technical report, University of California, Berkeley.

Beyene, K.M., Chen, D.G., and Kifle, Y.G. (2024). A novel nonparametric time‐dependent precision–recall curve estimator for right‐censored survival data. \emph{Biometrical Journal}, 66(3), 2300135.

Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373-3396.

Heagerty, P.J., and Zheng, Y. (2005). Survival model predictive accuracy and ROC curves. \emph{Biometrics}, 61(1), 92-105.

Li, L., Greene, T. and Hu, B. (2016).  A simple method to estimate the time-dependent receiver operating characteristic curve and the area under the curve with right censored data, \emph{Statistical Methods in Medical Research}, 27(8): 2264-2278.

Sheather, S.J. and Jones, M.C. (1991). A Reliable data-based bandwidth selection method for kernel density estimation. \emph{Journal of the Royal Statistical Society}. Series B (Methodological) 53(3): 683-690.
}
\author{
{
Kassu Mehari Beyene, Ding-Geng Chen and Yehenew Getachew Kifle

Maintainer: Kassu Mehari Beyene \code{<m2kassu@gmail.com> }
}
}
\keyword{package}
