% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-within.R
\name{within.qenv}
\alias{within.qenv}
\alias{within}
\title{Evaluate code in \code{qenv}}
\usage{
\method{within}{qenv}(data, expr, ...)
}
\arguments{
\item{data}{(\code{qenv})}

\item{expr}{(\code{expression}) to evaluate. Must be inline code, see \verb{Using language objects...}}

\item{...}{named argument value will substitute a symbol in the \code{expr} matched by the name.
For practical usage see Examples section below.}
}
\description{
Evaluate code in \code{qenv}
}
\details{
\code{within()} is a convenience method that wraps \code{eval_code} to provide a simplified way of passing expression.
\code{within} accepts only inline expressions (both simple and compound) and allows to substitute \code{expr}
with \code{...} named argument values.
Functions that trigger side effects like \code{options} or \code{set.seed} can be
linked to specific objects for further code retrieval (with \code{get_code}), but
only through \code{eval_code} where code input as \code{character}. \code{within} works on
\code{expressions} that do not preserve comments, hence you can not use \verb{# @linksto} tag explained in \code{get_code}.
}
\section{Using language objects with \code{within}}{

Passing language objects to \code{expr} is generally not intended but can be achieved with \code{do.call}.
Only single \code{expression}s will work and substitution is not available. See examples.
}

\examples{
# evaluate code using within
q <- qenv()
q <- within(q, {
  i <- iris
})
q <- within(q, {
  m <- mtcars
  f <- faithful
})
q
get_code(q)

# inject values into code
q <- qenv()
q <- within(q, i <- iris)
within(q, print(dim(subset(i, Species == "virginica"))))
within(q, print(dim(subset(i, Species == species)))) # fails
within(q, print(dim(subset(i, Species == species))), species = "versicolor")
species_external <- "versicolor"
within(q, print(dim(subset(i, Species == species))), species = species_external)

# pass language objects
expr <- expression(i <- iris, m <- mtcars)
within(q, expr) # fails
do.call(within, list(q, expr))

exprlist <- list(expression(i <- iris), expression(m <- mtcars))
within(q, exprlist) # fails
do.call(within, list(q, do.call(c, exprlist)))

}
