% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{rayleigh_test}
\alias{rayleigh_test}
\title{Rayleigh Test of Circular Uniformity}
\usage{
rayleigh_test(x, mu = NULL, axial = TRUE, quiet = FALSE)
}
\arguments{
\item{x}{numeric vector. Values in degrees}

\item{mu}{(optional) The specified or known mean direction (in degrees) in
alternative hypothesis}

\item{axial}{logical. Whether the data are axial, i.e. \eqn{\pi}-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{quiet}{logical. Prints the test's decision.}
}
\value{
a list with the components:
\describe{
\item{\code{R} or \code{C}}{mean resultant length or the dispersion (if \code{mu} is
specified). Small values of \code{R} (large values of \code{C}) will reject
uniformity. Negative values of \code{C} indicate that vectors point in opposite
directions (also lead to rejection).}
\item{\code{statistic}}{test statistic}
\item{\code{p.value}}{significance level of the test statistic}
}
}
\description{
Performs a Rayleigh test for uniformity of circular/directional data by
assessing the significance of the mean resultant length.
}
\details{
\describe{
\item{\eqn{H_0}{H0}:}{angles are randomly distributed around the circle.}
\item{\eqn{H_1}{H1}:}{angles are from non-uniformly distribution with unknown mean
direction and mean resultant length (when \code{mu} is \code{NULL}. Alternatively (when
\code{mu} is specified),
angles are non-uniformly distributed around a specified direction.}
}
If \code{statistic > p.value}, the null hypothesis is rejected,
i.e. the length of the mean resultant differs significantly from zero, and
the angles are not randomly distributed.
}
\note{
Although the Rayleigh test is consistent against (non-uniform)
von Mises alternatives, it is not consistent against alternatives with
\code{p = 0} (in particular, distributions with antipodal symmetry, i.e. axial
data). Tests of non-uniformity which are consistent against all alternatives
include Kuiper's test (\code{\link[=kuiper_test]{kuiper_test()}}) and Watson's \eqn{U^2} test
(\code{\link[=watson_test]{watson_test()}}).
}
\examples{
# Example data from Mardia and Jupp (1999), pp. 93
pidgeon_homing <- c(55, 60, 65, 95, 100, 110, 260, 275, 285, 295)
rayleigh_test(pidgeon_homing, axial = FALSE) # Do not reject null hypothesis.
# R = 0.22; stat = 0.497, p = 0.62

# Example data from Davis (1986), pp. 316
finland_striae <- c(
  23, 27, 53, 58, 64, 83, 85, 88, 93, 99, 100, 105, 113,
  113, 114, 117, 121, 123, 125, 126, 126, 126, 127, 127, 128, 128, 129, 132,
  132, 132, 134, 135, 137, 144, 145, 145, 146, 153, 155, 155, 155, 157, 163,
  165, 171, 172, 179, 181, 186, 190, 212
)
rayleigh_test(finland_striae, axial = FALSE) # reject null hypothesis
rayleigh_test(finland_striae, mu = 105, axial = FALSE) # reject null hypothesis

# Example data from Mardia and Jupp (1999), pp. 99
atomic_weight <- c(
  rep(0, 12), rep(3.6, 1), rep(36, 6), rep(72, 1),
  rep(108, 2), rep(169.2, 1), rep(324, 1)
)
rayleigh_test(atomic_weight, 0, axial = FALSE) # reject null hypothesis

# San Andreas Fault Data:
data(san_andreas)
rayleigh_test(san_andreas$azi) # reject null hypothesis
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
rayleigh_test(sa.por$azi.PoR, mu = 135) # reject null hypothesis
}
\references{
Fisher, N. I. (1993) Statistical Analysis of Circular Data, Cambridge
University Press.
}
\seealso{
\code{\link[=mean_resultant_length]{mean_resultant_length()}}, \code{\link[=circular_mean]{circular_mean()}}, \code{\link[=norm_chisq]{norm_chisq()}},
\code{\link[=kuiper_test]{kuiper_test()}}, \code{\link[=watson_test]{watson_test()}}, \code{\link[=weighted_rayleigh]{weighted_rayleigh()}}
}
