% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-clustering.R
\name{tidy_pam}
\alias{tidy_pam}
\title{Tidy PAM (Partitioning Around Medoids)}
\usage{
tidy_pam(data, k, metric = "euclidean", cols = NULL)
}
\arguments{
\item{data}{A data frame, tibble, or dist object}

\item{k}{Number of clusters}

\item{metric}{Distance metric (default: "euclidean"). Use "gower" for mixed data types.}

\item{cols}{Columns to include (tidy select). If NULL, uses all columns.}
}
\value{
A list of class "tidy_pam" containing:
\itemize{
\item clusters: tibble with observation IDs and cluster assignments
\item medoids: tibble of medoid indices and values
\item silhouette: average silhouette width
\item model: original pam object
}
}
\description{
Performs PAM clustering with tidy output
}
\examples{
# PAM with Euclidean distance
pam_result <- tidy_pam(iris, k = 3)

# PAM with Gower distance for mixed data
pam_result <- tidy_pam(mtcars, k = 3, metric = "gower")

}
