% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm.R
\docType{data}
\name{dtm}
\alias{dtm}
\title{Document-Term Matrix (Sparse)}
\format{
A sparse matrix of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}
  with text unit IDs as row names and lemma headwords as column names.
}
\usage{
dtm
}
\description{
Sparse document-term matrix computed from \code{\link{lemmas}}.
Each row is a text unit, each column is a lemma, and values are
frequencies (proportions). Stored as a \code{dgCMatrix} from the
Matrix package. Computed on first access.
}
\examples{
\donttest{
# Sparse document-term matrix
dim(dtm)

# Hierarchical clustering of text units
d <- dist(dtm[1:20, ])
plot(hclust(d))
}

}
\keyword{datasets}
