% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_lemma.R
\name{search_lemma}
\alias{search_lemma}
\title{Search for Lemma Occurrences}
\usage{
search_lemma(lemma)
}
\arguments{
\item{lemma}{Character string of the lemma to search for.}
}
\value{
A data frame of occurrences with columns: word, n, total, freq,
  id, collection, pitaka. Returns an empty data frame if the lemma is
  not found.
}
\description{
Finds all text units containing a specific lemma, sorted by frequency
(most frequent first).
}
\examples{
\donttest{
# Find texts mentioning "nibbana"
nibbana <- search_lemma("nibbana")
head(nibbana)

# Find texts mentioning "dhamma"
dhamma <- search_lemma("dhamma")
head(dhamma[, c("id", "collection", "n", "freq")])
}

}
