% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_validate.R
\name{assert_toon}
\alias{assert_toon}
\title{Assert TOON validity}
\usage{
assert_toon(
  x,
  is_file = FALSE,
  strict = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE
)
}
\arguments{
\item{x}{Character scalar containing TOON text, or file path if is_file=TRUE.}

\item{is_file}{Logical. If TRUE, x is treated as a file path.}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys.}
}
\value{
Invisibly returns TRUE if valid.
}
\description{
Assert TOON validity
}
\details{
Throws \code{toonlite_parse_error} condition if invalid, with attached
location and snippet information.
}
\examples{
# Valid TOON (returns invisibly)
assert_toon('name: "Alice"')

# Invalid TOON (throws error)
\dontrun{
assert_toon('invalid: [')
}

}
