% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_validate.R
\name{toon_info}
\alias{toon_info}
\title{Get TOON file info}
\usage{
toon_info(file, allow_comments = TRUE)
}
\arguments{
\item{file}{Character scalar. Path to TOON file.}

\item{allow_comments}{Logical. If TRUE (default), allow comments.}
}
\value{
A list with components:
\itemize{
\item array_count: Integer. Number of arrays in file.
\item object_count: Integer. Number of objects in file.
\item has_tabular: Logical. Whether file contains tabular arrays.
\item declared_rows: Integer or NA. Declared row count if tabular.
}
}
\description{
Get TOON file info
}
\examples{
\dontrun{
info <- toon_info("data.toon")
cat("Arrays:", info$array_count, "\n")
cat("Has tabular:", info$has_tabular, "\n")
}

}
