% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajClusters.R
\name{trajClusters}
\alias{trajClusters}
\alias{print.trajClusters}
\alias{summary.trajClusters}
\title{Classify the Longitudinal Data Based on the Measures.}
\usage{
trajClusters(
  Measures,
  select = NULL,
  fuzzy = FALSE,
  nclusters = NULL,
  nstart = 50
)

\method{print}{trajClusters}(x, ...)

\method{summary}{trajClusters}(object, ...)
}
\arguments{
\item{Measures}{object of class \code{trajMeasures} as returned by the function
\code{trajMeasures()}.}

\item{select}{an optional vector of positive integers corresponding to the
measures to use in the clustering. Defaults to \code{NULL}, which uses all the measures contained in \code{Measures}.}

\item{fuzzy}{logical. If FALSE, each trajectory is assigned to a unique group. If TRUE, each trajectory is assigned a "degree of membership" to each group. Defaults to FALSE.}

\item{nclusters}{The desired number of clusters. If \code{NULL}, clustering is carried out for every number of clusters between 2 and (up to) 8 and the "best" number of clusters is used, as judged by the combination of three internal cluster validity indices. See section 'Value' for more details. Defaults to \code{NULL}.}

\item{nstart}{The number of random starts. Defaults to \code{50}.}

\item{x}{object of class \code{trajClusters}.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class \code{trajClusters}.}
}
\value{
An object of class \code{trajClusters}; a list containing the result of the clustering, as well as a curated form of the arguments. If \code{nclusters} is set to \code{NULL}, clustering is carried out for each number \eqn{k} of clusters between 2 and (up to) 8 and a plot is produced representing the value of three internal cluster validity indices (C-index, Calinski-Harabasz, Wemmert-Gancarski) as a function of \eqn{k}. As in the 'KmL' package of Genolini et al., these validity indices are presented on a scale from 0 to 1, with 1 corresponding to the highest validity score and 0 corresponding to the lowest. From this, a "best" value of \eqn{k} is determined using a ranked voting system.
}
\description{
Classifies the trajectories by applying a nonparametric clustering algorithm to the measures computed by \code{trajMeasures()}.
}
\details{
The spectral clustering algorithm presented in Meila (2005) is implemented in which the similarity matrix \eqn{S} is built from a binary K nearest neighbors similarity function (\eqn{S=(W+W^T)/2}, where \eqn{W_{ij}=1} if data point \eqn{j} is among the nearest points to data point \eqn{i} and \eqn{W_{ij}=0} otherwise).
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] # remove the Group column

m = trajMeasures(trajdata.noGrp, ID = TRUE, measures = 1:19)

s2.3 <- trajClusters(m, nclusters = 3)
plot(s2.3)

#'s2.4 <- trajClusters(m, nclusters = 4)
plot(s2.4)

#'s2.5 <- trajClusters(m, nclusters = 5)
plot(s2.5)

groups <- s2.4 <- trajClusters(m, nclusters = 4)$partition
}


}
\references{
Genolini, C. et al., kml: K-Means for Longitudinal Data, https://CRAN.R-project.org/package=kml

Meila, M., Spectral Clustering. Handbook of Cluster Analysis, Chapter 7, Chapman and Hall/CRC, 2005.
}
